/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.correomqtt.business.dispatcher.ApplicationLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ShortcutDispatcher;
import org.correomqtt.business.model.SettingsDTO;
import org.correomqtt.business.services.ConfigService;
import org.correomqtt.business.utils.VersionUtils;
import org.correomqtt.gui.controller.AlertController;
import org.correomqtt.gui.controller.MainViewController;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.utils.CheckNewVersionUtils;
import org.correomqtt.gui.utils.HostServicesHolder;
import org.correomqtt.plugin.manager.PluginSystem;
import org.correomqtt.plugin.update.PluginUpdateManager;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorreoMqtt
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorreoMqtt.class);
    private ResourceBundle resources;
    private MainViewController mainViewController;
    private Scene scene;

    public static void main(String[] args) {
        CorreoMqtt.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        LOGGER.info("Application started.");
        LOGGER.info("JVM: {} | {} | {}.", new Object[]{System.getProperty("java.vendor"), System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")});
        LOGGER.info("CorreoMQTT version is {}.", (Object)VersionUtils.getVersion());
        SettingsDTO settings = ConfigService.getInstance().getSettings();
        if (settings.getSavedLocale() == null) {
            if (Locale.getDefault().getLanguage().equals("de") && Locale.getDefault().getCountry().equals("DE")) {
                settings.setSavedLocale(new Locale("de", "DE"));
            } else {
                settings.setSavedLocale(new Locale("en", "US"));
            }
        }
        settings.setCurrentLocale(settings.getSavedLocale());
        ConfigService.getInstance().saveSettings();
        this.resources = ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale());
        LOGGER.info("Locale is: {}", (Object)settings.getSavedLocale());
        HostServicesHolder.getInstance().setHostServices(this.getHostServices());
        this.setLoggerFilePath();
        this.loadPrimaryStage(primaryStage);
        settings = ConfigService.getInstance().getSettings();
        if (settings.isFirstStart()) {
            boolean checkForUpdates = AlertHelper.confirm(this.resources.getString("settingsViewUpdateLabel"), this.resources.getString("firstStartCheckForUpdatesTitle"), "", this.resources.getString("commonNoButton"), this.resources.getString("commonYesButton"));
            settings.setFirstStart(false);
            if (checkForUpdates) {
                settings.setSearchUpdates(true);
            } else {
                settings.setSearchUpdates(false);
            }
            ConfigService.getInstance().saveSettings();
        }
        if ((settings = ConfigService.getInstance().getSettings()).isSearchUpdates()) {
            this.checkForUpdates();
        }
        AlertController.activate();
    }

    private void checkForUpdates() throws IOException, ParseException {
        PluginSystem pluginSystem = PluginSystem.getInstance();
        pluginSystem.loadPlugins();
        new PluginUpdateManager(pluginSystem).updateSystem();
        pluginSystem.startPlugins();
        CheckNewVersionUtils.checkNewVersion(false);
    }

    private void loadPrimaryStage(Stage primaryStage) throws IOException, ParseException {
        ConfigService.getInstance().setCssFileName();
        String cssPath = ConfigService.getInstance().getCssPath();
        FXMLLoader loader = new FXMLLoader(MainViewController.class.getResource("mainView.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale()));
        Parent root = (Parent)loader.load();
        this.mainViewController = (MainViewController)loader.getController();
        primaryStage.setTitle("CorreoMQTT v" + VersionUtils.getVersion());
        this.scene = new Scene(root, 900.0, 800.0);
        if (cssPath != null) {
            this.scene.getStylesheets().add((Object)cssPath);
        }
        primaryStage.setScene(this.scene);
        primaryStage.setMinHeight(400.0);
        primaryStage.setMinWidth(850.0);
        primaryStage.show();
        primaryStage.setOnCloseRequest(t -> {
            LOGGER.info("Main window closed. Initialize shutdown.");
            LOGGER.info("Shutting down connections.");
            ApplicationLifecycleDispatcher.getInstance().onShutdown();
            LOGGER.info("Shutting down plugins.");
            PluginSystem.getInstance().stopPlugins();
            LOGGER.info("Shutting down application. Bye.");
            Platform.exit();
            System.exit(0);
        });
        this.setupShortcut();
    }

    private void setupShortcut() {
        this.scene.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode().equals((Object)KeyCode.S) && event.isShortcutDown() && !event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onSubscriptionShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
            if (event.getCode().equals((Object)KeyCode.S) && event.isShortcutDown() && event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onClearIncomingShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
            if (event.getCode().equals((Object)KeyCode.P) && event.isShortcutDown() && !event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onPublishShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
            if (event.getCode().equals((Object)KeyCode.P) && event.isShortcutDown() && event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onClearOutgoingShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
        });
    }

    private void setLoggerFilePath() {
        System.setProperty("correomqtt-logfile", ConfigService.getInstance().getLogPath());
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ContextInitializer ci = new ContextInitializer(lc);
        lc.reset();
        try {
            ci.autoConfig();
        }
        catch (JoranException e) {
            e.printStackTrace();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
    }
}

