/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.dispatcher;

import java.util.function.Consumer;
import org.correomqtt.business.dispatcher.BaseConnectionObserver;
import org.correomqtt.business.dispatcher.BaseDispatcher;
import org.correomqtt.business.utils.ConnectionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public abstract class BaseConnectionDispatcher<T extends BaseConnectionObserver>
extends BaseDispatcher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseConnectionDispatcher.class);

    void triggerFiltered(String connectionId, Consumer<T> trigger) {
        String callerString = this.getCallerString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MarkerFactory.getMarker((String)ConnectionHolder.getInstance().getConfig(connectionId).getName()), "Trigger with connectionId {}: {}", (Object)connectionId, (Object)callerString);
        }
        this.observer.stream().filter(o -> o.getConnectionId() != null).filter(o -> o.getConnectionId().equals(connectionId)).forEach(o -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(MarkerFactory.getMarker((String)ConnectionHolder.getInstance().getConfig(connectionId).getName()), "Trigger with connectionId {}: {} -> {}", new Object[]{connectionId, callerString, o.getClass().getSimpleName()});
            }
            trigger.accept(o);
        });
    }
}

