/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.dispatcher;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.correomqtt.business.dispatcher.BaseConnectionDispatcher;
import org.correomqtt.business.dispatcher.BaseObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDispatcher<T extends BaseObserver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseConnectionDispatcher.class);
    protected Set<T> observer = new HashSet<T>();

    public void addObserver(T observer) {
        this.observer.add(observer);
    }

    public void removeObserver(T observer) {
        this.observer.remove(observer);
    }

    void trigger(Consumer<T> trigger) {
        String callerString = this.getCallerString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trigger: {}", (Object)callerString);
        }
        this.observer.forEach(o -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Trigger: {} -> {}", (Object)callerString, (Object)o.getClass().getSimpleName());
            }
            trigger.accept(o);
        });
    }

    String getCallerString() {
        if (LOGGER.isDebugEnabled()) {
            StackTraceElement st = Thread.currentThread().getStackTrace()[3];
            String fullClassName = st.getClassName();
            String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            return simpleClassName + "." + st.getMethodName() + ":" + st.getLineNumber();
        }
        return null;
    }
}

