/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.dispatcher;

import java.util.concurrent.atomic.AtomicInteger;
import org.correomqtt.business.dispatcher.BaseConnectionDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;

public class ConnectionLifecycleDispatcher
extends BaseConnectionDispatcher<ConnectionLifecycleObserver> {
    private static ConnectionLifecycleDispatcher instance;

    private ConnectionLifecycleDispatcher() {
    }

    public static synchronized ConnectionLifecycleDispatcher getInstance() {
        if (instance == null) {
            instance = new ConnectionLifecycleDispatcher();
        }
        return instance;
    }

    public void onConnect(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onConnect);
    }

    public void onConnectRunning(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onConnectRunning);
    }

    public void onConnectionFailed(String connectionId, Throwable exception) {
        this.triggerFiltered(connectionId, o -> o.onConnectionFailed(exception));
    }

    public void onConnectionLost(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onConnectionLost);
    }

    public void onConnectionReconnected(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onConnectionReconnected);
    }

    public void onConnectionCanceled(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onConnectionCanceled);
    }

    public void onConnectScheduled(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onConnectScheduled);
    }

    public void onDisconnect(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onDisconnect);
        this.trigger(o -> o.onDisconnectFromConnectionDeleted(connectionId));
    }

    public void onDisconnectRunning(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onDisconnectRunning);
    }

    public void onDisconnectFailed(String connectionId, Throwable exception) {
        this.triggerFiltered(connectionId, o -> o.onDisconnectFailed(exception));
    }

    public void onDisconnectCanceled(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onDisconnectCanceled);
    }

    public void onDisconnectScheduled(String connectionId) {
        this.triggerFiltered(connectionId, ConnectionLifecycleObserver::onDisconnectScheduled);
    }

    public void onReconnectFailed(String connectionId, AtomicInteger triedReconnects, int maxReconnects) {
        this.triggerFiltered(connectionId, o -> o.onReconnectFailed(triedReconnects, maxReconnects));
    }
}

