/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hivemq.client.mqtt.MqttVersion;
import org.correomqtt.gui.model.GenericCellModel;

public enum CorreoMqttVersion implements GenericCellModel
{
    MQTT_3_1_1(MqttVersion.MQTT_3_1_1, "MQTT v3.1.1"),
    MQTT_5_0(MqttVersion.MQTT_5_0, "MQTT v5.0");

    private MqttVersion version;
    private String description;

    private CorreoMqttVersion(MqttVersion version, String description) {
        this.version = version;
        this.description = description;
    }

    public MqttVersion getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonCreator
    public static CorreoMqttVersion fromJsonValue(String value) {
        try {
            return CorreoMqttVersion.valueOf(value);
        }
        catch (IllegalArgumentException iae) {
            return MQTT_3_1_1;
        }
    }

    @JsonValue
    public String toJsonValue() {
        return this.name();
    }

    public String toString() {
        return this.description;
    }

    @Override
    public String getLabelTranslationKey() {
        return null;
    }
}

