/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.mqtt;

import org.correomqtt.business.exception.CorreoMqttUnsupportedMqttVersionException;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.mqtt.CorreoMqtt3Client;
import org.correomqtt.business.mqtt.CorreoMqtt5Client;
import org.correomqtt.business.mqtt.CorreoMqttClient;

public class CorreoMqttClientFactory {
    private CorreoMqttClientFactory() {
    }

    public static CorreoMqttClient createClient(ConnectionConfigDTO configDTO) {
        switch (configDTO.getMqttVersion()) {
            case MQTT_3_1_1: {
                return new CorreoMqtt3Client(configDTO);
            }
            case MQTT_5_0: {
                return new CorreoMqtt5Client(configDTO);
            }
        }
        throw new CorreoMqttUnsupportedMqttVersionException();
    }
}

