/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.correomqtt.business.services.BaseUserFileService;
import org.correomqtt.business.services.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BasePersistHistoryService<D>
extends BaseUserFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePersistHistoryService.class);
    private String connectionId;

    abstract String getHistoryFileName();

    abstract Class<D> getDTOClass();

    public String getConnectionId() {
        return this.connectionId;
    }

    abstract void setDTO(String var1, D var2);

    BasePersistHistoryService(String id) {
        this.connectionId = id;
        String historyFileName = this.getHistoryFileName();
        try {
            this.prepareFile(id, historyFileName);
        }
        catch (IOException | SecurityException | UnsupportedOperationException | InvalidPathException e) {
            LOGGER.error("Error reading " + historyFileName, (Throwable)e);
            this.readingError(e);
        }
        try {
            this.setDTO(id, new ObjectMapper().readValue(this.getFile(), this.getDTOClass()));
        }
        catch (IOException e) {
            LOGGER.error("Error reading " + historyFileName, (Throwable)e);
            this.readingError(e);
        }
    }

    protected abstract void readingError(Exception var1);

    protected void removeFileIfConnectionDeleted() {
        ConfigService.getInstance().getConnectionConfigs().stream().filter(c -> c.getId().equals(this.getConnectionId())).findFirst().ifPresentOrElse(c -> {}, () -> {
            if (this.getFile().delete()) {
                LOGGER.info(this.getFile() + " deleted successfully");
            } else {
                LOGGER.info("Failed to delete " + this.getFile());
            }
        });
    }
}

