/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.mqtt.CorreoMqttClient;
import org.correomqtt.business.mqtt.CorreoMqttClientFactory;
import org.correomqtt.business.services.BaseService;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.business.utils.CorreoMqttConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectService
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectService.class);

    public ConnectService(String connectionId) {
        super(connectionId);
    }

    public void connect() {
        CorreoMqttConnection connection = ConnectionHolder.getInstance().getConnection(this.connectionId);
        connection.setClient(CorreoMqttClientFactory.createClient(connection.getConfigDTO()));
        this.callSafeOnClient(CorreoMqttClient::connect);
    }

    @Override
    public void onSucceeded() {
        LOGGER.info(this.getConnectionMarker(), "Connecting to broker successfully.");
        ConnectionLifecycleDispatcher.getInstance().onConnect(this.connectionId);
    }

    @Override
    public void onCancelled() {
        LOGGER.info(this.getConnectionMarker(), "Connecting to broker cancelled.");
        ConnectionLifecycleDispatcher.getInstance().onConnectionCanceled(this.connectionId);
    }

    @Override
    public void onFailed(Throwable exception) {
        LOGGER.info(this.getConnectionMarker(), "Connecting to broker failed: ", exception);
        ConnectionLifecycleDispatcher.getInstance().onConnectionFailed(this.connectionId, exception);
    }

    @Override
    public void onRunning() {
        LOGGER.debug(this.getConnectionMarker(), "Connecting to broker running.");
        ConnectionLifecycleDispatcher.getInstance().onConnectRunning(this.connectionId);
    }

    @Override
    public void onScheduled() {
        LOGGER.debug(this.getConnectionMarker(), "Connecting to broker scheduled.");
        ConnectionLifecycleDispatcher.getInstance().onConnectScheduled(this.connectionId);
    }
}

