/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.services.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectService
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectService.class);

    public DisconnectService(String connectionId) {
        super(connectionId);
    }

    public void disconnect() {
        LOGGER.info(this.getConnectionMarker(), "Start disconnecting.");
        this.callSafeOnClient(c -> c.disconnect(true));
    }

    @Override
    public void onSucceeded() {
        LOGGER.info(this.getConnectionMarker(), "Disconnected.");
        this.getConnection().setClient(null);
        ConnectionLifecycleDispatcher.getInstance().onDisconnect(this.connectionId);
    }

    @Override
    public void onCancelled() {
        LOGGER.info(this.getConnectionMarker(), "Disconnect cancelled");
        ConnectionLifecycleDispatcher.getInstance().onDisconnectCanceled(this.connectionId);
    }

    @Override
    public void onFailed(Throwable exception) {
        LOGGER.warn(this.getConnectionMarker(), "Disconnecting from broker failed.", exception);
        ConnectionLifecycleDispatcher.getInstance().onDisconnectFailed(this.connectionId, exception);
    }

    @Override
    public void onRunning() {
        LOGGER.debug(this.getConnectionMarker(), "Disconnect running.");
        ConnectionLifecycleDispatcher.getInstance().onDisconnectRunning(this.connectionId);
    }

    @Override
    public void onScheduled() {
        LOGGER.debug(this.getConnectionMarker(), "Disconnect scheduled.");
        ConnectionLifecycleDispatcher.getInstance().onDisconnectScheduled(this.connectionId);
    }
}

