/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.correomqtt.business.dispatcher.ExportMessageDispatcher;
import org.correomqtt.business.exception.CorreoMqttExportMessageException;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.services.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportMessageService
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportMessageService.class);
    private final File file;
    private final MessageDTO messageDTO;

    public ExportMessageService(String connectionId, File file, MessageDTO messageDTO) {
        super(connectionId);
        this.file = file;
        this.messageDTO = messageDTO;
    }

    public void exportMessage() {
        ExportMessageDispatcher.getInstance().onExportStarted(this.connectionId, this.file, this.messageDTO);
        LOGGER.info(this.getConnectionMarker(), "Start exporting message {} to file {}.", (Object)this.messageDTO.getMessageId(), (Object)this.file.getAbsolutePath());
        try {
            new ObjectMapper().writeValue(this.file, (Object)this.messageDTO);
        }
        catch (IOException e) {
            throw new CorreoMqttExportMessageException(e);
        }
    }

    @Override
    public void onSucceeded() {
        LOGGER.info(this.getConnectionMarker(), "Exporting message {} to file {} succeeded.", (Object)this.messageDTO.getMessageId(), (Object)this.file.getAbsolutePath());
        ExportMessageDispatcher.getInstance().onExportSucceeded(this.connectionId);
    }

    @Override
    public void onCancelled() {
        LOGGER.info(this.getConnectionMarker(), "Exporting message {} to file {} cancelled.", (Object)this.messageDTO.getMessageId(), (Object)this.file.getAbsolutePath());
        ExportMessageDispatcher.getInstance().onExportCancelled(this.connectionId, this.file, this.messageDTO);
    }

    @Override
    public void onFailed(Throwable exception) {
        LOGGER.warn(this.getConnectionMarker(), "Exporting message {} to file {} failed.", new Object[]{this.messageDTO.getMessageId(), this.file.getAbsolutePath(), exception});
        ExportMessageDispatcher.getInstance().onExportFailed(this.connectionId, this.file, this.messageDTO, exception);
    }

    @Override
    public void onRunning() {
        LOGGER.info(this.getConnectionMarker(), "Exporting message {} to file {} running.", (Object)this.messageDTO.getMessageId(), (Object)this.file.getAbsolutePath());
        ExportMessageDispatcher.getInstance().onExportRunning(this.connectionId);
    }

    @Override
    public void onScheduled() {
        LOGGER.info(this.getConnectionMarker(), "Exporting message {} to file {} scheduled.", (Object)this.messageDTO.getMessageId(), (Object)this.file.getAbsolutePath());
        ExportMessageDispatcher.getInstance().onExportScheduled(this.connectionId);
    }
}

