/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.correomqtt.business.dispatcher.ImportMessageDispatcher;
import org.correomqtt.business.exception.CorreoMqttExportMessageException;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.services.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportMessageService
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportMessageService.class);
    private final File file;
    private MessageDTO messageDTO;

    public ImportMessageService(String connectionId, File file) {
        super(connectionId);
        this.file = file;
    }

    public void importMessage() {
        ImportMessageDispatcher.getInstance().onImportStarted(this.connectionId, this.file);
        LOGGER.info(this.getConnectionMarker(), "Start importing message from file {}.", (Object)this.file.getAbsolutePath());
        try {
            this.messageDTO = (MessageDTO)new ObjectMapper().readValue(this.file, MessageDTO.class);
        }
        catch (IOException e) {
            throw new CorreoMqttExportMessageException(e);
        }
    }

    @Override
    public void onSucceeded() {
        LOGGER.info(this.getConnectionMarker(), "Importing message from file {} succeeded", (Object)this.file.getAbsolutePath());
        ImportMessageDispatcher.getInstance().onImportSucceeded(this.connectionId, this.messageDTO);
    }

    @Override
    public void onCancelled() {
        LOGGER.info(this.getConnectionMarker(), "Importing message from file {} cancelled", (Object)this.file.getAbsolutePath());
        ImportMessageDispatcher.getInstance().onImportCancelled(this.connectionId, this.file);
    }

    @Override
    public void onFailed(Throwable exception) {
        LOGGER.info(this.getConnectionMarker(), "Importing message from file {} failed.", (Object)this.file.getAbsolutePath(), (Object)exception);
        ImportMessageDispatcher.getInstance().onImportFailed(this.connectionId, this.file, exception);
    }

    @Override
    public void onRunning() {
        LOGGER.info(this.getConnectionMarker(), "Importing message from file {} running.", (Object)this.file.getAbsolutePath());
        ImportMessageDispatcher.getInstance().onImportRunning(this.connectionId);
    }

    @Override
    public void onScheduled() {
        LOGGER.info(this.getConnectionMarker(), "Importing message from file {} scheduled.", (Object)this.file.getAbsolutePath());
        ImportMessageDispatcher.getInstance().onImportScheduled(this.connectionId);
    }
}

