/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.business;

import java.util.function.Consumer;
import javafx.concurrent.Task;
import org.correomqtt.business.services.BusinessService;

class ServiceTask<S extends BusinessService>
extends Task<Void> {
    private final S backendService;
    private final Consumer<S> consumer;

    ServiceTask(S backendService, Consumer<S> consumer) {
        this.backendService = backendService;
        this.consumer = consumer;
    }

    protected Void call() {
        this.consumer.accept(this.backendService);
        return null;
    }

    protected void succeeded() {
        this.backendService.onSucceeded();
    }

    protected void cancelled() {
        this.backendService.onCancelled();
    }

    protected void failed() {
        this.backendService.onFailed(super.getException());
    }

    protected void running() {
        this.backendService.onRunning();
    }

    protected void scheduled() {
        this.backendService.onScheduled();
    }
}

