/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.business;

import java.io.File;
import org.correomqtt.business.services.ConnectService;
import org.correomqtt.business.services.DisconnectService;
import org.correomqtt.business.services.ExportMessageService;
import org.correomqtt.business.services.ImportMessageService;
import org.correomqtt.business.services.PublishService;
import org.correomqtt.business.services.SubscribeService;
import org.correomqtt.business.services.UnsubscribeService;
import org.correomqtt.gui.business.GuiService;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.correomqtt.gui.model.SubscriptionPropertiesDTO;
import org.correomqtt.gui.transformer.MessageTransformer;
import org.correomqtt.gui.transformer.SubscriptionTransformer;
import org.correomqtt.plugin.manager.PluginSystem;
import org.correomqtt.plugin.model.MessageExtensionDTO;
import org.correomqtt.plugin.spi.PublishMessageHook;

public class TaskFactory {
    private TaskFactory() {
    }

    public static void publish(String connectionId, MessagePropertiesDTO messagePropertiesDTO) {
        messagePropertiesDTO = TaskFactory.executeOnPublishMessageExtensions(connectionId, messagePropertiesDTO);
        new GuiService<PublishService>(new PublishService(connectionId, MessageTransformer.propsToDTO(messagePropertiesDTO)), PublishService::publish).start();
    }

    private static MessagePropertiesDTO executeOnPublishMessageExtensions(String connectionId, MessagePropertiesDTO messagePropertiesDTO) {
        MessageExtensionDTO messageExtensionDTO = new MessageExtensionDTO(messagePropertiesDTO);
        for (PublishMessageHook p : PluginSystem.getInstance().getExtensions(PublishMessageHook.class)) {
            messageExtensionDTO = p.onPublishMessage(connectionId, messageExtensionDTO);
        }
        return messageExtensionDTO.merge(messagePropertiesDTO);
    }

    public static void subscribe(String connectionId, SubscriptionPropertiesDTO subscriptionDTO) {
        new GuiService<SubscribeService>(new SubscribeService(connectionId, SubscriptionTransformer.propsToDTO(subscriptionDTO)), SubscribeService::subscribe).start();
    }

    public static void unsubscribe(String connectionId, SubscriptionPropertiesDTO subscriptionPropertiesDTO) {
        new GuiService<UnsubscribeService>(new UnsubscribeService(connectionId, SubscriptionTransformer.propsToDTO(subscriptionPropertiesDTO)), UnsubscribeService::unsubscribe).start();
    }

    public static void connect(String connectionId) {
        new GuiService<ConnectService>(new ConnectService(connectionId), ConnectService::connect).start();
    }

    public static void disconnect(String connectionId) {
        new GuiService<DisconnectService>(new DisconnectService(connectionId), DisconnectService::disconnect).start();
    }

    public static void importMessage(String connectionId, File file) {
        new GuiService<ImportMessageService>(new ImportMessageService(connectionId, file), ImportMessageService::importMessage).start();
    }

    public static void exportMessage(String connectionId, File file, MessagePropertiesDTO messageDTO) {
        new GuiService<ExportMessageService>(new ExportMessageService(connectionId, file, MessageTransformer.propsToDTO(messageDTO)), ExportMessageService::exportMessage).start();
    }
}

