/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.cell;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import org.correomqtt.business.services.ConfigService;
import org.correomqtt.gui.model.GenericCellModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericCell<T extends GenericCellModel>
extends ListCell<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericCell.class);
    private final ListView<T> listView;
    @FXML
    private Pane mainNode;
    @FXML
    private Label label;
    @FXML
    private ResourceBundle resources;
    private FXMLLoader loader;

    public GenericCell(ListView<T> listView) {
        this.listView = listView;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.loader == null) {
                try {
                    this.loader = new FXMLLoader(GenericCell.class.getResource("genericCell.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale()));
                    this.loader.setController((Object)this);
                    this.loader.load();
                }
                catch (Exception e) {
                    LOGGER.error("Exception rendering generic cell:", (Throwable)e);
                    this.setText(this.resources.getString("commonRowCreationError"));
                    this.setGraphic(null);
                    return;
                }
            }
            this.mainNode.prefWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20));
            String translationKey = item.getLabelTranslationKey();
            if (translationKey != null) {
                this.label.setText(this.resources.getString(translationKey));
            } else {
                this.label.setText(item.toString());
            }
            this.setText(null);
            this.setGraphic((Node)this.mainNode);
        }
    }
}

