/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.cell;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import org.correomqtt.business.model.Qos;
import org.correomqtt.business.services.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QosCell
extends ListCell<Qos> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QosCell.class);
    private final ListView<Qos> listView;
    @FXML
    private Pane mainNode;
    @FXML
    private Label nameLabel;
    @FXML
    private Label descriptionLabel;
    @FXML
    private ResourceBundle resources;
    private FXMLLoader loader;

    public QosCell(ListView<Qos> listView) {
        this.listView = listView;
    }

    protected void updateItem(Qos qos, boolean empty) {
        super.updateItem((Object)qos, empty);
        if (empty || qos == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.loader == null) {
                try {
                    this.loader = new FXMLLoader(QosCell.class.getResource("qosCell.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale()));
                    this.loader.setController((Object)this);
                    this.loader.load();
                }
                catch (Exception e) {
                    LOGGER.error("Exception rendering qos cell:", (Throwable)e);
                    this.setText(this.resources.getString("commonRowCreationError"));
                    this.setGraphic(null);
                    return;
                }
            }
            this.mainNode.prefWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20));
            this.setQos(qos);
            this.setText(null);
            this.setGraphic((Node)this.mainNode);
        }
    }

    private void setQos(Qos qos) {
        this.nameLabel.setText(qos.toString());
        this.descriptionLabel.setText(this.resources.getString(qos.getDescription()));
    }
}

