/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.cell;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import org.correomqtt.business.services.ConfigService;
import org.correomqtt.gui.model.SubscriptionPropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionViewCell
extends ListCell<SubscriptionPropertiesDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionViewCell.class);
    private final ListView<SubscriptionPropertiesDTO> listView;
    @FXML
    private Label topicLabel;
    @FXML
    private Label qosTag;
    @FXML
    private CheckBox filterCheckbox;
    @FXML
    private Pane mainNode;
    @FXML
    private ResourceBundle resources;
    private FXMLLoader loader;

    public SubscriptionViewCell(ListView<SubscriptionPropertiesDTO> listView) {
        this.listView = listView;
    }

    protected void updateItem(SubscriptionPropertiesDTO subscriptionDTO, boolean empty) {
        super.updateItem((Object)subscriptionDTO, empty);
        if (empty || subscriptionDTO == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.loader == null) {
                try {
                    this.loader = new FXMLLoader(SubscriptionViewCell.class.getResource("subscriptionView.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale()));
                    this.loader.setController((Object)this);
                    this.loader.load();
                }
                catch (Exception e) {
                    LOGGER.error("Exception rendering subscription:", (Throwable)e);
                    this.setText(this.resources.getString("commonRowCreationError"));
                    this.setGraphic(null);
                    return;
                }
            }
            this.mainNode.prefWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20));
            this.setUpSubscription(subscriptionDTO);
            this.setText(null);
            this.setGraphic((Node)this.mainNode);
        }
    }

    @FXML
    public void onFilteredChanged(ActionEvent event) {
        ((SubscriptionPropertiesDTO)this.getItem()).setFiltered(this.filterCheckbox.isSelected());
    }

    private void setUpSubscription(SubscriptionPropertiesDTO subscriptionDTO) {
        this.topicLabel.setText(subscriptionDTO.getTopic());
        this.qosTag.setText(subscriptionDTO.getQos().toString());
        this.filterCheckbox.setSelected(subscriptionDTO.isFiltered());
    }
}

