/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.cell;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import org.correomqtt.business.model.SysTopic;
import org.correomqtt.business.services.ConfigService;
import org.correomqtt.gui.model.SysTopicPropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysTopicCell
extends ListCell<SysTopicPropertiesDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysTopicCell.class);
    private final ListView<SysTopicPropertiesDTO> listView;
    @FXML
    private Pane mainNode;
    @FXML
    private Label topicLabel;
    @FXML
    private Label translationLabel;
    @FXML
    private Label descriptionLabel;
    @FXML
    private Label valueLabel;
    @FXML
    private ResourceBundle resources;
    private FXMLLoader loader;
    private SysTopicPropertiesDTO sysTopicDTO;

    public SysTopicCell(ListView<SysTopicPropertiesDTO> listView) {
        this.listView = listView;
    }

    protected void updateItem(SysTopicPropertiesDTO sysTopicDTO, boolean empty) {
        super.updateItem((Object)sysTopicDTO, empty);
        if (empty || sysTopicDTO == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.loader == null) {
                try {
                    this.loader = new FXMLLoader(SysTopicCell.class.getResource("sysTopicCell.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale()));
                    this.loader.setController((Object)this);
                    this.loader.load();
                }
                catch (Exception e) {
                    LOGGER.error("Exception receiving message:", (Throwable)e);
                    this.setText(this.resources.getString("commonRowCreationError"));
                    this.setGraphic(null);
                    return;
                }
            }
            this.mainNode.prefWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20));
            this.setupSysTopic(sysTopicDTO);
            this.setText(null);
            this.setGraphic((Node)this.mainNode);
        }
    }

    private void setupSysTopic(SysTopicPropertiesDTO sysTopicDTO) {
        this.sysTopicDTO = sysTopicDTO;
        SysTopic sysTopic = SysTopic.getSysTopicByTopic(sysTopicDTO.getTopic());
        if (sysTopic == null) {
            this.topicLabel.setText(sysTopicDTO.getTopic());
            this.descriptionLabel.setText("");
        } else {
            this.topicLabel.setText(this.resources.getString(sysTopic.getTranslation()));
            this.descriptionLabel.setText(this.resources.getString(sysTopic.getDescription()));
        }
        this.valueLabel.setText(sysTopicDTO.getAggregatedPayload());
    }
}

