/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.contextmenu;

import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.correomqtt.business.services.ConfigService;
import org.correomqtt.gui.contextmenu.BaseObjectContextMenu;
import org.correomqtt.gui.contextmenu.SubscriptionListMessageContextMenuDelegate;
import org.correomqtt.gui.model.SubscriptionPropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionListMessageContextMenu
extends BaseObjectContextMenu<SubscriptionPropertiesDTO, SubscriptionListMessageContextMenuDelegate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionListMessageContextMenu.class);
    private MenuItem unsubscribe;
    private MenuItem filter;
    private MenuItem filterOnly;
    private MenuItem selectAll;
    private MenuItem selectNone;
    private MenuItem unsubscribeAll;
    private SeparatorMenuItem separator1;
    private SeparatorMenuItem separator2;
    private ResourceBundle resources;

    public SubscriptionListMessageContextMenu(SubscriptionListMessageContextMenuDelegate dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void initializeItems() {
        this.resources = ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale());
        super.initializeItems();
        this.unsubscribe = new MenuItem("Unsubscribe");
        this.unsubscribe.setOnAction(this::unsubcribe);
        this.filter = new MenuItem("Toggle Filter");
        this.filter.setOnAction(this::toggleFilter);
        this.filterOnly = new MenuItem(this.resources.getString("subscriptionListMessageContextMenuFilterOnlyMenuItem"));
        this.filterOnly.setOnAction(this::filterOnly);
        this.selectAll = new MenuItem(this.resources.getString("subscriptionListMessageContextMenuSelectAllMenuItem"));
        this.selectAll.setOnAction(this::selectAll);
        this.selectNone = new MenuItem(this.resources.getString("subscriptionListMessageContextMenuSelectNoneMenuItem"));
        this.selectNone.setOnAction(this::selectNone);
        this.unsubscribeAll = new MenuItem(this.resources.getString("subscriptionListMessageContextMenuUnsubscribeAllMenuItem"));
        this.unsubscribeAll.setOnAction(this::unsubscribeAll);
        this.separator1 = new SeparatorMenuItem();
        this.separator2 = new SeparatorMenuItem();
        this.getItems().addAll((Object[])new MenuItem[]{this.unsubscribe, this.filter, this.filterOnly, this.separator1, this.selectAll, this.selectNone, this.separator2, this.unsubscribeAll});
    }

    @Override
    protected void setVisibilityForObjectItems(boolean visible) {
        super.setVisibilityForObjectItems(visible);
        this.unsubscribe.setVisible(visible);
        this.filter.setVisible(visible);
        this.filterOnly.setVisible(visible);
        this.separator1.setVisible(visible);
    }

    private void unsubscribeAll(ActionEvent actionEvent) {
        ((SubscriptionListMessageContextMenuDelegate)this.delegate).unsubscribeAll();
    }

    private void selectNone(ActionEvent actionEvent) {
        ((SubscriptionListMessageContextMenuDelegate)this.delegate).selectNone();
    }

    private void selectAll(ActionEvent actionEvent) {
        ((SubscriptionListMessageContextMenuDelegate)this.delegate).selectAll();
    }

    private void filterOnly(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((SubscriptionListMessageContextMenuDelegate)this.delegate).filterOnly((SubscriptionPropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::filterOnly with empty message.", (Object)this.getClassName());
        }
    }

    private void toggleFilter(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((SubscriptionPropertiesDTO)this.dto).setFiltered(!((SubscriptionPropertiesDTO)this.dto).isFiltered());
        } else {
            LOGGER.warn("Call to {}::toggleFilter with empty message.", (Object)this.getClassName());
        }
    }

    private void unsubcribe(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((SubscriptionListMessageContextMenuDelegate)this.delegate).unsubscribe((SubscriptionPropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::unsubcribe with empty message.", (Object)this.getClassName());
        }
    }
}

