/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ResourceBundle;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.dispatcher.PersistPublishHistoryObserver;
import org.correomqtt.business.dispatcher.PersistSubscriptionHistoryObserver;
import org.correomqtt.business.services.ConfigService;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.helper.AlertHelper;

public class AlertController
extends BaseController
implements ConfigObserver,
PersistPublishHistoryObserver,
PersistSubscriptionHistoryObserver {
    private ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", ConfigService.getInstance().getSettings().getCurrentLocale());
    private static AlertController instance;

    private AlertController() {
        ConfigDispatcher.getInstance().addObserver(this);
    }

    public static void activate() {
        if (instance == null) {
            instance = new AlertController();
        }
    }

    @Override
    public void onConfigDirectoryEmpty() {
        AlertHelper.warn(this.resources.getString("alertControllerWarnTitle"), this.resources.getString("alertControllerOnConfigDirectoryEmptyContent"));
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
        AlertHelper.warn(this.resources.getString("alertControllerWarnTitle"), this.resources.getString("alertControllerOnConfigDirectoryNotAccessibleContent"));
    }

    @Override
    public void onAppDataNull() {
        AlertHelper.warn(this.resources.getString("alertControllerWarnTitle"), this.resources.getString("alertControllerOnAppDataNullContent"));
    }

    @Override
    public void onUserHomeNull() {
        AlertHelper.warn(this.resources.getString("alertControllerWarnTitle"), this.resources.getString("alertControllerOnUserHomeNullContent"));
    }

    @Override
    public void onFileAlreadyExists() {
        AlertHelper.warn(this.resources.getString("alertControllerOnFileAlreadyExistsTitle"), this.resources.getString("alertControllerOnFileAlreadyExistsContent"));
    }

    @Override
    public void onInvalidPath() {
        AlertHelper.warn(this.resources.getString("alertControllerOnInvalidPathTitle"), this.resources.getString("alertControllerOnInvalidPathContent"));
    }

    @Override
    public void onInvalidJsonFormat() {
        AlertHelper.warn(this.resources.getString("alertControllerOnInvalidJsonFormatTitle"), this.resources.getString("alertControllerOnInvalidJsonFormatContent"));
    }

    @Override
    public void onSavingFailed() {
        AlertHelper.warn(this.resources.getString("alertControllerOnSavingFailedTitle"), this.resources.getString("alertControllerOnSavingFailedContent"));
    }

    @Override
    public void onConnectionsUpdated() {
    }

    @Override
    public void onConfigPrepareFailed() {
        AlertHelper.warn("Exception", this.resources.getString("alertControllerOnConfigPrepareFailedContent"));
    }

    @Override
    public void onSettingsUpdated() {
        AlertHelper.info(this.resources.getString("alertControllerOnSettingsUpdatedTitle"), this.resources.getString("alertControllerOnSettingsUpdatedContent"));
    }

    @Override
    public void updateSubscriptions(String connectionId) {
    }

    @Override
    public void errorReadingSubscriptionHistory(Throwable exception) {
        AlertHelper.warn("Exception", this.resources.getString("alertControllerErrorReadingSubscriptionHistoryContent") + exception.getLocalizedMessage());
    }

    @Override
    public String getConnectionId() {
        return null;
    }

    @Override
    public void errorReadingPublishHistory(Throwable exception) {
        AlertHelper.warn("Exception", this.resources.getString("alertControllerErrorReadingPublishHistoryContent") + exception.getLocalizedMessage());
    }

    @Override
    public void errorWritingPublishHistory(Throwable exception) {
        AlertHelper.warn("Exception", this.resources.getString("alertControllerErrorWritingPublishHistoryContent") + exception.getLocalizedMessage());
    }

    @Override
    public void updatedPublishes(String connectionId) {
    }

    @Override
    public void errorWritingSubscriptionHistory(Throwable exception) {
        AlertHelper.warn("Exception", this.resources.getString("alertControllerErrorWritingSubscriptionHistoryContent") + exception.getLocalizedMessage());
    }
}

