/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class BaseDetailSaveController
extends BaseConnectionController {
    BaseDetailSaveController(String connectionId) {
        super(connectionId);
    }

    public String setGson(String finalMessage) {
        String prettyJsonString;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(finalMessage);
        finalMessage = prettyJsonString = gson.toJson(je);
        return finalMessage;
    }

    public String setXml(String finalMessage) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(finalMessage)));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            finalMessage = writer.getBuffer().toString().replaceAll("(?m)^\\s*$[\n\r]{1,}", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return finalMessage;
    }
}

