/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.File;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Pane;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.dispatcher.ExportMessageDispatcher;
import org.correomqtt.business.dispatcher.ExportMessageObserver;
import org.correomqtt.business.dispatcher.ImportMessageDispatcher;
import org.correomqtt.business.dispatcher.ImportMessageObserver;
import org.correomqtt.business.dispatcher.LogDispatcher;
import org.correomqtt.business.dispatcher.LogObserver;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.gui.business.TaskFactory;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.ConnectionViewDelegate;
import org.correomqtt.gui.controller.ControlBarController;
import org.correomqtt.gui.controller.ControlBarDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.LoadingViewController;
import org.correomqtt.gui.controller.PublishViewController;
import org.correomqtt.gui.controller.PublishViewDelegate;
import org.correomqtt.gui.controller.SubscriptionViewController;
import org.correomqtt.gui.controller.SubscriptionViewDelegate;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.model.ConnectionPropertiesDTO;
import org.correomqtt.gui.model.ConnectionState;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionViewController
extends BaseConnectionController
implements LogObserver,
ConnectionLifecycleObserver,
ExportMessageObserver,
ImportMessageObserver,
PublishViewDelegate,
SubscriptionViewDelegate,
ControlBarDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionViewController.class);
    private final ConnectionViewDelegate delegate;
    @FXML
    private Pane connectionHolder;
    @FXML
    private SplitPane splitPane;
    private boolean splitMessageDetails;
    private Pane publishPane;
    private Pane subscribePane;
    private Pane controlBarPane;
    private LoadingViewController loadingViewController;
    private PublishViewController publishController;
    private static ResourceBundle resources;

    public ConnectionViewController(String connectionId, ConnectionViewDelegate delegate) {
        super(connectionId);
        this.delegate = delegate;
        LogDispatcher.getInstance().addObserver(this);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        ExportMessageDispatcher.getInstance().addObserver(this);
        ImportMessageDispatcher.getInstance().addObserver(this);
    }

    public static LoaderResult<ConnectionViewController> load(String connectionId, ConnectionViewDelegate delegate) {
        return ConnectionViewController.load(ConnectionViewController.class, "connectionView.fxml", () -> new ConnectionViewController(connectionId, delegate));
    }

    @FXML
    public void initialize() {
        LoaderResult<PublishViewController> publishLoadResult = PublishViewController.load(this.getConnectionId(), this);
        LoaderResult<SubscriptionViewController> subscriptionLoadResult = SubscriptionViewController.load(this.getConnectionId(), this);
        LoaderResult<ControlBarController> controlBarLoadResult = ControlBarController.load(this.getConnectionId(), this);
        this.publishPane = publishLoadResult.getMainPane();
        this.subscribePane = subscriptionLoadResult.getMainPane();
        this.controlBarPane = controlBarLoadResult.getMainPane();
        this.publishController = publishLoadResult.getController();
        resources = controlBarLoadResult.getResourceBundle();
        this.connectionHolder.getChildren().add(0, (Object)this.controlBarPane);
        this.splitPane.getItems().add((Object)this.publishPane);
        this.splitPane.getItems().add((Object)this.subscribePane);
    }

    @Override
    public void updateLog(String message) {
    }

    @Override
    public void setLayout(boolean publish, boolean subscribe) {
        if (publish && !subscribe) {
            this.splitPane.getItems().remove((Object)this.subscribePane);
            if (!this.splitPane.getItems().contains((Object)this.publishPane)) {
                this.splitPane.getItems().add(0, (Object)this.publishPane);
            }
        } else if (!publish && subscribe) {
            this.splitPane.getItems().remove((Object)this.publishPane);
            if (!this.splitPane.getItems().contains((Object)this.subscribePane)) {
                this.splitPane.getItems().add(0, (Object)this.subscribePane);
            }
        } else {
            if (!this.splitPane.getItems().contains((Object)this.subscribePane)) {
                this.splitPane.getItems().add((Object)this.subscribePane);
            }
            if (!this.splitPane.getItems().contains((Object)this.publishPane)) {
                this.splitPane.getItems().add(0, (Object)this.publishPane);
            }
        }
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
        Platform.runLater(() -> this.splitPane.setDisable(false));
    }

    @Override
    public void onConnectRunning() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onConnectionFailed(Throwable message) {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onConnectionCanceled() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onConnectionLost() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onDisconnect() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
        this.delegate.onDisconnect();
    }

    @Override
    public void onConnectScheduled() {
    }

    @Override
    public void onDisconnectCanceled() {
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onDisconnectScheduled() {
    }

    @Override
    public void onConnectionReconnected() {
        this.splitPane.setDisable(false);
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }

    public void disconnect() {
        TaskFactory.disconnect(this.getConnectionId());
    }

    public Pane getMainNode() {
        return this.connectionHolder;
    }

    public void connect(ConnectionPropertiesDTO config) {
        this.splitPane.setDisable(true);
        this.setConnectionId(config.getId());
        TaskFactory.connect(this.getConnectionId());
    }

    @Override
    public void onExportStarted(File file, MessageDTO messageDTO) {
        Platform.runLater(() -> {
            this.splitPane.setDisable(true);
            this.loadingViewController = LoadingViewController.showAsDialog(this.getConnectionId(), resources.getString("connectionViewControllerExportTitle") + " " + file.getAbsolutePath());
        });
    }

    @Override
    public void onExportSucceeded() {
        this.disableLoading();
    }

    @Override
    public void onExportCancelled(File file, MessageDTO messageDTO) {
        this.disableLoading();
        AlertHelper.warn(resources.getString("connectionViewControllerExportCancelledTitle"), resources.getString("connectionViewControllerExportCancelledContent"));
    }

    @Override
    public void onExportFailed(File file, MessageDTO messageDTO, Throwable exception) {
        this.disableLoading();
        AlertHelper.warn(resources.getString("connectionViewControllerExportFailedTitle"), resources.getString("connectionViewControllerExportFailedContent") + exception.getLocalizedMessage());
    }

    @Override
    public void onExportRunning() {
    }

    @Override
    public void onExportScheduled() {
    }

    @Override
    public void onImportStarted(File file) {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onImportSucceeded(MessageDTO messageDTO) {
        this.disableLoading();
    }

    @Override
    public void onImportCancelled(File file) {
        this.disableLoading();
    }

    @Override
    public void onImportFailed(File file, Throwable exception) {
        this.disableLoading();
    }

    @Override
    public void onImportRunning() {
    }

    @Override
    public void onImportScheduled() {
    }

    private void disableLoading() {
        Platform.runLater(() -> {
            this.splitPane.setDisable(false);
            if (this.loadingViewController != null) {
                this.loadingViewController.close();
                this.loadingViewController = null;
            }
        });
    }

    @Override
    public void setUpToForm(MessagePropertiesDTO messageDTO) {
        if (this.publishController != null) {
            this.publishController.setUpToForm(messageDTO);
        }
    }

    @Override
    public void setConnectionState(ConnectionState state) {
        this.delegate.setConnectionState(this.getTabId(), state);
    }

    @Override
    public void setTabDirty() {
        this.delegate.setTabDirty(this.getTabId());
    }
}

