/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ResourceBundle;
import javafx.scene.layout.Pane;
import org.correomqtt.gui.controller.BaseController;

class LoaderResult<C extends BaseController> {
    private final C controller;
    private final Pane mainPane;
    private final ResourceBundle resourceBundle;

    public static <C extends BaseController> LoaderResultBuilder<C> builder() {
        return new LoaderResultBuilder();
    }

    public C getController() {
        return this.controller;
    }

    public Pane getMainPane() {
        return this.mainPane;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public LoaderResult(C controller, Pane mainPane, ResourceBundle resourceBundle) {
        this.controller = controller;
        this.mainPane = mainPane;
        this.resourceBundle = resourceBundle;
    }

    public static class LoaderResultBuilder<C extends BaseController> {
        private C controller;
        private Pane mainPane;
        private ResourceBundle resourceBundle;

        LoaderResultBuilder() {
        }

        public LoaderResultBuilder<C> controller(C controller) {
            this.controller = controller;
            return this;
        }

        public LoaderResultBuilder<C> mainPane(Pane mainPane) {
            this.mainPane = mainPane;
            return this;
        }

        public LoaderResultBuilder<C> resourceBundle(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
            return this;
        }

        public LoaderResult<C> build() {
            return new LoaderResult<C>(this.controller, this.mainPane, this.resourceBundle);
        }

        public String toString() {
            return "LoaderResult.LoaderResultBuilder(controller=" + this.controller + ", mainPane=" + this.mainPane + ", resourceBundle=" + this.resourceBundle + ")";
        }
    }
}

