/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.correomqtt.business.model.SettingsDTO;
import org.correomqtt.business.model.ThemeDTO;
import org.correomqtt.business.model.ThemeSettingsDTO;
import org.correomqtt.business.services.ConfigService;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.SubscriptionViewController;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsViewController
extends BaseController {
    private static ResourceBundle resources;
    @FXML
    private CheckBox unzipCheckBox;
    @FXML
    private CheckBox base64CheckBox;
    @FXML
    private ComboBox<ThemeDTO> themeComboBox;
    @FXML
    private ComboBox<Locale> languageComboBox;
    @FXML
    private CheckBox searchUpdatesCheckbox;
    private SettingsDTO settings;
    private ThemeSettingsDTO themeSettings;
    private static final Logger LOGGER;

    public static LoaderResult<SettingsViewController> load() {
        return SettingsViewController.load(SettingsViewController.class, "settingsView.fxml");
    }

    public static LoaderResult<SettingsViewController> showAsDialog() {
        LoaderResult<SettingsViewController> result = SettingsViewController.load();
        resources = result.getResourceBundle();
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.SETTINGS);
        SettingsViewController.showAsDialog(result, resources.getString("settingsViewControllerTitle"), properties, false, false, null, (EventHandler<KeyEvent>)((EventHandler)event -> ((SettingsViewController)result.getController()).keyHandling((KeyEvent)event)));
        return result;
    }

    @FXML
    public void initialize() {
        this.settings = ConfigService.getInstance().getSettings();
        this.themeSettings = ConfigService.getInstance().getThemeSettings();
        this.setupGUI();
        this.themeComboBox.setOnAction(actionEvent -> this.onThemeChanged());
        this.languageComboBox.setOnAction(actionEvent -> this.onLanguageChanged());
    }

    private void onLanguageChanged() {
    }

    @FXML
    public void onCancelClicked() {
        LOGGER.debug("Cancel in settings clicked");
        this.closeDialog();
    }

    @FXML
    public void onSaveClicked() {
        LOGGER.debug("Save in settings clicked");
        this.saveSettings();
        this.closeDialog();
    }

    @FXML
    public void onThemeChanged() {
        LOGGER.debug("Theme changed in settings");
    }

    private void setupGUI() {
        this.unzipCheckBox.setSelected(this.settings.isUnzippingPayload());
        this.base64CheckBox.setSelected(this.settings.isBase64DecodingPayload());
        this.searchUpdatesCheckbox.setSelected(this.settings.isSearchUpdates());
        ArrayList themes = new ArrayList();
        this.themeSettings.getThemes().forEach(t -> themes.add(t));
        this.themeComboBox.setOnAction(null);
        this.themeComboBox.setItems(FXCollections.observableArrayList(themes));
        this.themeComboBox.setConverter((StringConverter)new StringConverter<ThemeDTO>(){

            public String toString(ThemeDTO object) {
                if (object == null) {
                    return null;
                }
                return object.getName();
            }

            public ThemeDTO fromString(String string) {
                return null;
            }
        });
        this.themeComboBox.getSelectionModel().select((Object)this.themeSettings.getActiveTheme());
        this.languageComboBox.setConverter((StringConverter)new StringConverter<Locale>(){

            public String toString(Locale object) {
                return StringUtils.capitalize((String)object.getDisplayLanguage(object));
            }

            public Locale fromString(String string) {
                return null;
            }
        });
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (Locale locale : Locale.getAvailableLocales()) {
            if (SettingsViewController.class.getResource("/org/correomqtt/i18n_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties") == null) continue;
            availableLocales.add(locale);
        }
        this.languageComboBox.setItems(FXCollections.observableArrayList((Collection)availableLocales.stream().filter(SettingsViewController.distinctByKey(l -> l.getLanguage() + "_" + l.getCountry())).collect(Collectors.toList())));
        this.languageComboBox.getSelectionModel().select((Object)this.settings.getSavedLocale());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private void saveSettings() {
        LOGGER.debug("Saving settings");
        this.settings.setUnzippingPayload(this.unzipCheckBox.isSelected());
        this.settings.setBase64DecodingPayload(this.base64CheckBox.isSelected());
        this.settings.setSearchUpdates(this.searchUpdatesCheckbox.isSelected());
        ThemeDTO selectedTheme = (ThemeDTO)this.themeComboBox.getSelectionModel().getSelectedItem();
        this.settings.setSavedLocale((Locale)this.languageComboBox.getSelectionModel().getSelectedItem());
        ConfigService.getInstance().saveSettings();
        this.themeSettings.setActiveTheme(selectedTheme);
        ConfigService.getInstance().saveThemeSettings();
    }

    private void closeDialog() {
        Stage stage = (Stage)this.themeComboBox.getScene().getWindow();
        stage.close();
    }

    private void keyHandling(KeyEvent event) {
        if (KeyCode.ESCAPE == event.getCode()) {
            this.closeDialog();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(SubscriptionViewController.class);
    }
}

