/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.stage.WindowEvent;
import org.correomqtt.business.dispatcher.SubscribeDispatcher;
import org.correomqtt.business.dispatcher.SubscribeObserver;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.model.Qos;
import org.correomqtt.business.model.SubscriptionDTO;
import org.correomqtt.business.model.SysTopic;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.business.TaskFactory;
import org.correomqtt.gui.cell.SysTopicCell;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.helper.ClipboardHelper;
import org.correomqtt.gui.model.SubscriptionPropertiesDTO;
import org.correomqtt.gui.model.SysTopicPropertiesDTO;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.correomqtt.gui.transformer.SysTopicTransformer;
import org.correomqtt.gui.utils.WindowHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysTopicViewController
extends BaseConnectionController
implements SubscribeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysTopicViewController.class);
    private static final String SYS_TOPIC = "$SYS/#";
    private static ResourceBundle resources;
    private final SubscriptionPropertiesDTO subscriptionDTO = SubscriptionPropertiesDTO.builder().topic("$SYS/#").qos(Qos.AT_LEAST_ONCE).hidden(true).build();
    @FXML
    private Label connectionStatusLabel;
    @FXML
    private Label lastUpdateLabel;
    @FXML
    private ListView<SysTopicPropertiesDTO> listView;
    private ObservableList<SysTopicPropertiesDTO> sysTopics;
    private Set<SysTopicPropertiesDTO> plainSysTopics = new HashSet<SysTopicPropertiesDTO>();

    protected SysTopicViewController(String connectionId) {
        super(connectionId);
        SubscribeDispatcher.getInstance().addObserver(this);
    }

    public static void showAsDialog(String connectionId) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.SYSTOPIC);
        properties.put((Object)WindowProperty.CONNECTION_ID, connectionId);
        if (WindowHelper.focusWindowIfAlreadyThere(properties)) {
            return;
        }
        LoaderResult result = SysTopicViewController.load(SysTopicViewController.class, "sysTopicsView.fxml", connectionId);
        resources = result.getResourceBundle();
        SysTopicViewController.showAsDialog(result, resources.getString("sysTopicsViewControllerTitle") + " " + ConnectionHolder.getInstance().getConfig(connectionId).getName(), properties, true, false, (EventHandler<WindowEvent>)((EventHandler)event -> ((SysTopicViewController)result.getController()).onCloseDialog((WindowEvent)event)), null);
    }

    private void onCloseDialog(WindowEvent event) {
        TaskFactory.unsubscribe(this.getConnectionId(), this.subscriptionDTO);
    }

    @FXML
    private void initialize() {
        ConnectionConfigDTO configDTO = ConnectionHolder.getInstance().getConfig(this.getConnectionId());
        this.connectionStatusLabel.setText(configDTO.getUrl() + ":" + configDTO.getPort());
        this.lastUpdateLabel.setText("Last Update: no update yet");
        this.sysTopics = FXCollections.observableArrayList(SysTopicPropertiesDTO.extractor());
        this.listView.setItems(this.sysTopics);
        this.listView.setCellFactory(this::createCell);
        TaskFactory.subscribe(this.getConnectionId(), this.subscriptionDTO);
    }

    private ListCell<SysTopicPropertiesDTO> createCell(ListView<SysTopicPropertiesDTO> listView) {
        return new SysTopicCell(listView);
    }

    @FXML
    public void copyToClipboard() {
        ClipboardHelper.addToClipboard(this.plainSysTopics.stream().sorted(Comparator.comparingInt(st -> {
            int sortIndex = SysTopic.getSortIndex(st.getTopic());
            if (st.getSysTopic() != null && st.getSysTopic().isAggregated()) {
                String parsedComponent = st.getSysTopic().parseComponent(st.getTopic());
                return sortIndex * 20 + (parsedComponent == null ? 0 : Integer.parseInt(parsedComponent));
            }
            return sortIndex * 20;
        })).map(st -> st.getTopic() + "\t" + st.getPayload()).collect(Collectors.joining("\n")));
    }

    @Override
    public void onMessageIncoming(MessageDTO messageDTO, SubscriptionDTO subscriptionDTO) {
        if (!messageDTO.getTopic().startsWith("$SYS")) {
            return;
        }
        Platform.runLater(() -> this.insertIncomingMessage(messageDTO));
    }

    private void insertIncomingMessage(MessageDTO messageDTO) {
        SysTopic sysTopic = SysTopic.getSysTopicByTopic(messageDTO.getTopic());
        SysTopicPropertiesDTO newSysTopicDTO = SysTopicTransformer.dtoToProps(messageDTO, sysTopic);
        this.plainSysTopics.remove(newSysTopicDTO);
        this.plainSysTopics.add(newSysTopicDTO);
        SysTopicPropertiesDTO sysTopicDTO = this.sysTopics.stream().filter(st -> sysTopic == null && st.getTopic().equals(messageDTO.getTopic()) || sysTopic == st.getSysTopic()).findFirst().orElse(null);
        if (sysTopicDTO == null) {
            sysTopicDTO = newSysTopicDTO;
            this.sysTopics.add((Object)sysTopicDTO);
            this.sysTopics.sort(Comparator.comparingInt(st -> SysTopic.getSortIndex(st.getTopic())));
        }
        if (sysTopic != null && sysTopic.isAggregated()) {
            String parsedComponent = sysTopic.parseComponent(messageDTO.getTopic());
            if ("1".equals(parsedComponent)) {
                sysTopicDTO.setMin1(messageDTO.getPayload());
            } else if ("5".equals(parsedComponent)) {
                sysTopicDTO.setMin5(messageDTO.getPayload());
            } else if ("15".equals(parsedComponent)) {
                sysTopicDTO.setMin15(messageDTO.getPayload());
            }
        } else {
            sysTopicDTO.setPayload(messageDTO.getPayload());
        }
        this.lastUpdateLabel.setText(resources.getString("sysTopicsViewUpdateLabel") + ": " + LocalDateTime.now(ZoneOffset.UTC).toString());
    }

    @Override
    public void onSubscribedSucceeded(SubscriptionDTO subscriptionDTO) {
        if (SYS_TOPIC.equals(subscriptionDTO.getTopic())) {
            this.lastUpdateLabel.setText(resources.getString("sysTopicsViewControllerSubscriptionTo") + " " + subscriptionDTO.getTopic() + " " + resources.getString("sysTopicsViewControllerSucceeded"));
        }
    }

    @Override
    public void onSubscribedCanceled(SubscriptionDTO subscriptionDTO) {
        if (SYS_TOPIC.equals(subscriptionDTO.getTopic())) {
            this.lastUpdateLabel.setText(resources.getString("sysTopicsViewControllerSubscriptionTo") + " " + subscriptionDTO.getTopic() + " " + resources.getString("sysTopicsViewControllerCancelled"));
        }
    }

    @Override
    public void onSubscribedFailed(SubscriptionDTO subscriptionDTO, Throwable exception) {
        if (SYS_TOPIC.equals(subscriptionDTO.getTopic())) {
            this.lastUpdateLabel.setText(resources.getString("sysTopicsViewControllerSubscriptionTo") + " " + subscriptionDTO.getTopic() + " " + resources.getString("sysTopicsViewControllerFailed"));
        }
    }
}

