/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.helper;

import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;

public class CheckTopicHelper {
    private static final String TOPIC_IS_EMPTY = "Topic is empty";
    private static final String WILDCARDS_ARE_MISPLACED = "Wildcards are misplaced.";
    private static final String PUBLISH_TOPIC_MUST_NOT_CONTAIN_WILDCARDS = "Publish topic must not contain wildcards";
    private static final String TOPIC_IS_SYS_TOPIC = "Topics starting with $SYS are reserved.";

    public static boolean checkPublishTopic(ComboBox<String> comboBox, boolean save) {
        if (!CheckTopicHelper.checkRequired(comboBox)) {
            CheckTopicHelper.setError(comboBox, save, TOPIC_IS_EMPTY);
            return false;
        }
        if (comboBox.getEditor().getText().startsWith("$SYS")) {
            CheckTopicHelper.setError(comboBox, save, TOPIC_IS_SYS_TOPIC);
            return false;
        }
        try {
            if (MqttTopicFilter.of((String)comboBox.getEditor().getText()).containsWildcards()) {
                CheckTopicHelper.setError(comboBox, save, PUBLISH_TOPIC_MUST_NOT_CONTAIN_WILDCARDS);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            CheckTopicHelper.setError(comboBox, save, PUBLISH_TOPIC_MUST_NOT_CONTAIN_WILDCARDS);
            return false;
        }
        comboBox.getEditor().getStyleClass().removeAll((Object[])new String[]{"emptyError"});
        comboBox.getEditor().getStyleClass().removeAll((Object[])new String[]{"exclamationCircleSolid"});
        return true;
    }

    public static boolean checkSubscribeTopic(ComboBox<String> comboBox, boolean save, boolean afterSubscribe) {
        if (afterSubscribe) {
            return true;
        }
        if (!CheckTopicHelper.checkRequired(comboBox)) {
            CheckTopicHelper.setError(comboBox, save, TOPIC_IS_EMPTY);
            return false;
        }
        if (comboBox.getEditor().getText().startsWith("$SYS")) {
            CheckTopicHelper.setError(comboBox, save, TOPIC_IS_SYS_TOPIC);
            return false;
        }
        try {
            MqttTopicFilter.of((String)comboBox.getEditor().getText());
        }
        catch (IllegalArgumentException e) {
            CheckTopicHelper.setError(comboBox, save, WILDCARDS_ARE_MISPLACED);
            return false;
        }
        comboBox.getEditor().getStyleClass().removeAll((Object[])new String[]{"emptyError"});
        comboBox.getEditor().getStyleClass().removeAll((Object[])new String[]{"exclamationCircleSolid"});
        return true;
    }

    private static void setError(ComboBox<String> comboBox, boolean save, String tooltipText) {
        if (save) {
            comboBox.getEditor().getStyleClass().add((Object)"emptyError");
        }
        comboBox.setTooltip(new Tooltip(tooltipText));
        comboBox.getEditor().getStyleClass().add((Object)"exclamationCircleSolid");
    }

    private static boolean checkRequired(ComboBox<String> comboBox) {
        return comboBox.getEditor().getText() != null && !comboBox.getEditor().getText().isEmpty();
    }
}

