/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.UUID;
import org.correomqtt.business.model.MessageType;
import org.correomqtt.business.model.PublishStatus;
import org.correomqtt.business.model.Qos;
import org.correomqtt.business.utils.CorreoCharsetDecoder;
import org.correomqtt.business.utils.MessageDateTimeFormatter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageDTO
implements Comparable<MessageDTO> {
    private String topic;
    private String payload;
    private boolean isRetained;
    private Qos qos;
    @MessageDateTimeFormatter
    private LocalDateTime dateTime;
    private String messageId;
    private MessageType messageType;
    private PublishStatus publishStatus;

    public MessageDTO(Mqtt3Publish mqtt3Publish) {
        this.setTopic(mqtt3Publish.getTopic().toString());
        this.setQos(Qos.valueOf(mqtt3Publish.getQos()));
        this.setRetained(mqtt3Publish.isRetain());
        this.setPayload(CorreoCharsetDecoder.decode(mqtt3Publish.getPayloadAsBytes()));
        this.setDateTime(LocalDateTime.now(ZoneOffset.UTC));
        this.setMessageId(UUID.randomUUID().toString());
        this.setMessageType(MessageType.INCOMING);
    }

    public MessageDTO(Mqtt5Publish mqtt5Publish) {
        this.setTopic(mqtt5Publish.getTopic().toString());
        this.setQos(Qos.valueOf(mqtt5Publish.getQos()));
        this.setRetained(mqtt5Publish.isRetain());
        this.setPayload(CorreoCharsetDecoder.decode(mqtt5Publish.getPayloadAsBytes()));
        this.setDateTime(LocalDateTime.now(ZoneOffset.UTC));
        this.setMessageId(UUID.randomUUID().toString());
        this.setMessageType(MessageType.INCOMING);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDTO that = (MessageDTO)o;
        return this.isRetained() == that.isRetained() && this.getTopic().equals(that.getTopic()) && Objects.equals(this.getPayload(), that.getPayload()) && this.getQos() == that.getQos() && Objects.equals(this.getDateTime(), that.getDateTime());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTopic(), this.getPayload(), this.isRetained(), this.getQos(), this.getDateTime()});
    }

    @Override
    public int compareTo(MessageDTO o) {
        if (o == null || o.getDateTime() == null) {
            return this.getDateTime() == null ? 0 : 1;
        }
        return o.getDateTime().compareTo(this.getDateTime());
    }

    public static MessageDTOBuilder builder() {
        return new MessageDTOBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getPayload() {
        return this.payload;
    }

    public boolean isRetained() {
        return this.isRetained;
    }

    public Qos getQos() {
        return this.qos;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public PublishStatus getPublishStatus() {
        return this.publishStatus;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setRetained(boolean isRetained) {
        this.isRetained = isRetained;
    }

    public void setQos(Qos qos) {
        this.qos = qos;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setPublishStatus(PublishStatus publishStatus) {
        this.publishStatus = publishStatus;
    }

    public MessageDTO() {
    }

    public MessageDTO(String topic, String payload, boolean isRetained, Qos qos, LocalDateTime dateTime, String messageId, MessageType messageType, PublishStatus publishStatus) {
        this.topic = topic;
        this.payload = payload;
        this.isRetained = isRetained;
        this.qos = qos;
        this.dateTime = dateTime;
        this.messageId = messageId;
        this.messageType = messageType;
        this.publishStatus = publishStatus;
    }

    public static class MessageDTOBuilder {
        private String topic;
        private String payload;
        private boolean isRetained;
        private Qos qos;
        private LocalDateTime dateTime;
        private String messageId;
        private MessageType messageType;
        private PublishStatus publishStatus;

        MessageDTOBuilder() {
        }

        public MessageDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public MessageDTOBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public MessageDTOBuilder isRetained(boolean isRetained) {
            this.isRetained = isRetained;
            return this;
        }

        public MessageDTOBuilder qos(Qos qos) {
            this.qos = qos;
            return this;
        }

        public MessageDTOBuilder dateTime(LocalDateTime dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public MessageDTOBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public MessageDTOBuilder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public MessageDTOBuilder publishStatus(PublishStatus publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        public MessageDTO build() {
            return new MessageDTO(this.topic, this.payload, this.isRetained, this.qos, this.dateTime, this.messageId, this.messageType, this.publishStatus);
        }

        public String toString() {
            return "MessageDTO.MessageDTOBuilder(topic=" + this.topic + ", payload=" + this.payload + ", isRetained=" + this.isRetained + ", qos=" + this.qos + ", dateTime=" + this.dateTime + ", messageId=" + this.messageId + ", messageType=" + this.messageType + ", publishStatus=" + this.publishStatus + ")";
        }
    }
}

