/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.services.SettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseUserFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseUserFileService.class);
    private static final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String MAC_APP_FOLDER_NAME = "CorreoMqtt";
    private static final String WIN_APP_FOLDER_NAME = "CorreoMqtt";
    private static final String LIN_APP_FOLDER_NAME = ".correomqtt";
    private File file;
    private String targetDirectoryPathCache;

    protected File getFile() {
        return this.file;
    }

    void prepareFile(String id, String filename) throws IOException {
        File targetFile;
        String targetDirectoryPath = this.getTargetDirectoryPath();
        if (!new File(targetDirectoryPath).exists() && !new File(targetDirectoryPath).mkdir()) {
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        if (!(targetFile = id == null ? new File(targetDirectoryPath + File.separator + filename) : new File(targetDirectoryPath + File.separator + id + "_" + filename)).exists()) {
            try (InputStream inputStream = SettingsService.class.getResourceAsStream(filename);){
                byte[] buffer = new byte[inputStream.available()];
                inputStream.read(buffer);
                try (FileOutputStream outStream = new FileOutputStream(targetFile);){
                    ((OutputStream)outStream).write(buffer);
                }
            }
        }
        this.file = targetFile;
    }

    void prepareFile(String configFileName) throws IOException {
        this.prepareFile(null, configFileName);
    }

    void saveToUserDirectory(String filename, String content) {
        String targetDirectoryPath = this.getTargetDirectoryPath();
        if (!new File(targetDirectoryPath).exists() && !new File(targetDirectoryPath).mkdir()) {
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetDirectoryPath + File.separator + filename));){
            writer.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isMacOS() {
        return OPERATING_SYSTEM.contains("mac os");
    }

    public boolean isWindows() {
        return OPERATING_SYSTEM.startsWith("windows");
    }

    public boolean isLinux() {
        return OPERATING_SYSTEM.contains("linux") || OPERATING_SYSTEM.contains("mpe/ix") || OPERATING_SYSTEM.contains("freebsd") || OPERATING_SYSTEM.contains("irix") || OPERATING_SYSTEM.contains("digital unix") || OPERATING_SYSTEM.contains("unix");
    }

    public String getTargetDirectoryPath() {
        if (this.targetDirectoryPathCache != null) {
            return this.targetDirectoryPathCache;
        }
        if (this.isWindows()) {
            String appData = System.getenv("APPDATA");
            if (appData == null) {
                ConfigDispatcher.getInstance().onAppDataNull();
            } else {
                this.targetDirectoryPathCache = appData + File.separator + "CorreoMqtt";
            }
        } else if (this.isMacOS()) {
            if (USER_HOME == null) {
                ConfigDispatcher.getInstance().onUserHomeNull();
            } else {
                this.targetDirectoryPathCache = USER_HOME + File.separator + "Library" + File.separator + "Application Support" + File.separator + "CorreoMqtt";
            }
        } else if (this.isLinux()) {
            if (USER_HOME == null) {
                ConfigDispatcher.getInstance().onUserHomeNull();
            } else {
                this.targetDirectoryPathCache = USER_HOME + File.separator + LIN_APP_FOLDER_NAME;
            }
        } else {
            LOGGER.warn("User directory can not be found. Using working directory.");
            this.targetDirectoryPathCache = USER_DIR;
        }
        return this.targetDirectoryPathCache;
    }
}

