/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import java.io.File;
import org.correomqtt.business.services.BaseUserFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigService
extends BaseUserFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigService.class);
    private static final String PLUGIN_FOLDER = "plugins";
    private static final String PLUGIN_JAR_FOLDER = "jars";
    private static final String PLUGIN_CONFIG_FOLDER = "config";
    private static final String PROTOCOL_XML = "protocol.xml";
    private static ConfigService instance = null;

    public static synchronized ConfigService getInstance() {
        if (instance == null) {
            instance = new ConfigService();
            return instance;
        }
        return instance;
    }

    public String getPluginRootPath() {
        String pluginPath = this.getTargetDirectoryPath() + File.separator + PLUGIN_FOLDER;
        File pluginFolder = new File(pluginPath);
        if (!pluginFolder.exists() && !pluginFolder.mkdir()) {
            return null;
        }
        return pluginPath;
    }

    public String getPluginJarPath() {
        String pluginPath = this.getPluginRootPath() + File.separator + PLUGIN_JAR_FOLDER;
        File pluginFolder = new File(pluginPath);
        if (!pluginFolder.exists() && !pluginFolder.mkdir()) {
            return null;
        }
        return pluginPath;
    }

    public String getPluginConfigPath(String pluginId) {
        String pluginConfigFolderPath = this.getPluginRootPath() + File.separator + PLUGIN_CONFIG_FOLDER + File.separator + pluginId;
        File pluginConfigFolder = new File(pluginConfigFolderPath);
        if (!pluginConfigFolder.exists() && !pluginConfigFolder.mkdirs()) {
            return null;
        }
        return pluginConfigFolderPath;
    }

    public String getPluginProtocol() {
        return this.getPluginRootPath() + File.separator + PROTOCOL_XML;
    }
}

