/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.dispatcher.PersistPublishHistoryDispatcher;
import org.correomqtt.business.dispatcher.PublishGlobalDispatcher;
import org.correomqtt.business.dispatcher.PublishGlobalObserver;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.model.PublishMessageHistoryListDTO;
import org.correomqtt.business.services.BasePersistHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistPublishMessageHistoryService
extends BasePersistHistoryService<PublishMessageHistoryListDTO>
implements PublishGlobalObserver,
ConnectionLifecycleObserver,
ConfigObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistPublishMessageHistoryService.class);
    private static final String HISTORY_FILE_NAME = "publishMessageHistory.json";
    private static final int MAX_ENTRIES = 100;
    private static Map<String, PersistPublishMessageHistoryService> instances = new HashMap<String, PersistPublishMessageHistoryService>();
    private static Map<String, PublishMessageHistoryListDTO> historyDTOs = new HashMap<String, PublishMessageHistoryListDTO>();

    private PersistPublishMessageHistoryService(String id) {
        super(id);
        PublishGlobalDispatcher.getInstance().addObserver(this);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        ConfigDispatcher.getInstance().addObserver(this);
    }

    public static void activate(String id) {
        instances.computeIfAbsent(id, PersistPublishMessageHistoryService::new);
    }

    public static synchronized PersistPublishMessageHistoryService getInstance(String id) {
        return instances.computeIfAbsent(id, PersistPublishMessageHistoryService::new);
    }

    @Override
    protected void readingError(Exception e) {
        PersistPublishHistoryDispatcher.getInstance().errorReadingPublishHistory(e);
    }

    @Override
    String getHistoryFileName() {
        return HISTORY_FILE_NAME;
    }

    @Override
    Class<PublishMessageHistoryListDTO> getDTOClass() {
        return PublishMessageHistoryListDTO.class;
    }

    @Override
    void setDTO(String id, PublishMessageHistoryListDTO dto) {
        historyDTOs.put(id, dto);
    }

    public LinkedList<MessageDTO> getMessages(String connectionId) {
        return historyDTOs.get(connectionId).getMessages();
    }

    @Override
    public void onPublishSucceeded(String connectionId, MessageDTO messageDTO) {
        LOGGER.info("Persisting new publish history entry: {}", (Object)messageDTO.getTopic());
        LinkedList<MessageDTO> messageList = this.getMessages(connectionId);
        messageList.addFirst(messageDTO);
        while (messageList.size() > 100) {
            LOGGER.info("Removing last entry from publish history, cause limit of {} is reached.", (Object)100);
            messageList.removeLast();
        }
        this.saveHistory(connectionId);
    }

    private void saveHistory(String id) {
        try {
            new ObjectMapper().writeValue(this.getFile(), (Object)historyDTOs.get(id));
        }
        catch (IOException e) {
            LOGGER.error("Failed to write " + this.getHistoryFileName(), (Throwable)e);
            PersistPublishHistoryDispatcher.getInstance().errorWritingPublishHistory(e);
        }
    }

    @Override
    public void onPublishRemoved(String connectionId, MessageDTO messageDTO) {
        LOGGER.info("Removing {} from publish history for {}.", (Object)messageDTO.getTopic(), (Object)connectionId);
        LinkedList<MessageDTO> messageList = this.getMessages(connectionId);
        messageList.remove(messageDTO);
        this.saveHistory(connectionId);
    }

    @Override
    public void onPublishesCleared(String connectionId) {
        LOGGER.info("Clearing publish history for {}.", (Object)connectionId);
        LinkedList<MessageDTO> messageList = this.getMessages(connectionId);
        messageList.clear();
        this.saveHistory(connectionId);
    }

    @Override
    public void onConfigDirectoryEmpty() {
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
    }

    @Override
    public void onAppDataNull() {
    }

    @Override
    public void onUserHomeNull() {
    }

    @Override
    public void onFileAlreadyExists() {
    }

    @Override
    public void onInvalidPath() {
    }

    @Override
    public void onInvalidJsonFormat() {
    }

    @Override
    public void onSavingFailed() {
    }

    @Override
    public void onSettingsUpdated() {
    }

    @Override
    public void onConnectionsUpdated() {
        this.removeFileIfConnectionDeleted();
    }

    @Override
    public void onConfigPrepareFailed() {
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onConnectRunning() {
    }

    @Override
    public void onConnectionFailed(Throwable message) {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onDisconnect() {
        instances.remove(this.getConnectionId());
        historyDTOs.remove(this.getConnectionId());
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onConnectionReconnected() {
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }
}

