/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.dispatcher.PersistSubscriptionHistoryDispatcher;
import org.correomqtt.business.dispatcher.SubscribeGlobalDispatcher;
import org.correomqtt.business.dispatcher.SubscribeGlobalObserver;
import org.correomqtt.business.model.SubscriptionDTO;
import org.correomqtt.business.model.SubscriptionHistoryListDTO;
import org.correomqtt.business.services.BasePersistHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistSubscriptionHistoryService
extends BasePersistHistoryService<SubscriptionHistoryListDTO>
implements SubscribeGlobalObserver,
ConnectionLifecycleObserver,
ConfigObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistSubscriptionHistoryService.class);
    private static final String HISTORY_FILE_NAME = "subscriptionHistory.json";
    private static final int MAX_ENTRIES = 100;
    private static Map<String, PersistSubscriptionHistoryService> instances = new HashMap<String, PersistSubscriptionHistoryService>();
    private static Map<String, SubscriptionHistoryListDTO> historyDTOs = new HashMap<String, SubscriptionHistoryListDTO>();

    private PersistSubscriptionHistoryService(String id) {
        super(id);
        SubscribeGlobalDispatcher.getInstance().addObserver(this);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        ConfigDispatcher.getInstance().addObserver(this);
    }

    @Override
    protected void readingError(Exception e) {
        PersistSubscriptionHistoryDispatcher.getInstance().errorReadingSubscriptionHistory(e);
    }

    public static void activate(String id) {
        instances.computeIfAbsent(id, PersistSubscriptionHistoryService::new);
    }

    public static synchronized PersistSubscriptionHistoryService getInstance(String id) {
        return instances.computeIfAbsent(id, PersistSubscriptionHistoryService::new);
    }

    @Override
    String getHistoryFileName() {
        return HISTORY_FILE_NAME;
    }

    @Override
    Class<SubscriptionHistoryListDTO> getDTOClass() {
        return SubscriptionHistoryListDTO.class;
    }

    @Override
    void setDTO(String id, SubscriptionHistoryListDTO dto) {
        historyDTOs.put(id, dto);
    }

    public List<String> getTopics(String connectionId) {
        if (historyDTOs.get(connectionId) == null) {
            this.setDTO(connectionId, new SubscriptionHistoryListDTO(new ArrayList<String>()));
        }
        return historyDTOs.get(connectionId).getTopics();
    }

    @Override
    public void onSubscribedSucceeded(String connectionId, SubscriptionDTO subscriptionDTO) {
        if (subscriptionDTO.isHidden()) {
            return;
        }
        LOGGER.info("Persisting new subscription history entry: {}", (Object)subscriptionDTO.getTopic());
        List<String> topicsSet = this.getTopics(connectionId);
        String topic = subscriptionDTO.getTopic();
        topicsSet.remove(topic);
        topicsSet.add(topic);
        while (topicsSet.size() > 100) {
            LOGGER.info("Removing last entry from subscription history, cause limit of {} is reached.", (Object)100);
            topicsSet.remove(topicsSet.iterator().next());
        }
        this.saveHistory(connectionId);
    }

    private void saveHistory(String connectionId) {
        try {
            new ObjectMapper().writeValue(this.getFile(), (Object)historyDTOs.get(connectionId));
            PersistSubscriptionHistoryDispatcher.getInstance().updatedSubscriptions(connectionId);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write " + this.getHistoryFileName(), (Throwable)e);
            PersistSubscriptionHistoryDispatcher.getInstance().errorWritingSubscriptionHistory(e);
        }
    }

    @Override
    public void onSubscribeRemoved(String connectionId, SubscriptionDTO subscriptionDTO) {
    }

    @Override
    public void onSubscribeCleared(String connectionId) {
    }

    @Override
    public void onConfigDirectoryEmpty() {
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
    }

    @Override
    public void onAppDataNull() {
    }

    @Override
    public void onUserHomeNull() {
    }

    @Override
    public void onFileAlreadyExists() {
    }

    @Override
    public void onInvalidPath() {
    }

    @Override
    public void onInvalidJsonFormat() {
    }

    @Override
    public void onSavingFailed() {
    }

    @Override
    public void onSettingsUpdated() {
    }

    @Override
    public void onConnectionsUpdated() {
        this.removeFileIfConnectionDeleted();
    }

    @Override
    public void onConfigPrepareFailed() {
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onConnectRunning() {
    }

    @Override
    public void onConnectionFailed(Throwable message) {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onDisconnect() {
        instances.remove(this.getConnectionId());
        historyDTOs.remove(this.getConnectionId());
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onConnectionReconnected() {
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }
}

