/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.model.ConfigDTO;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.SettingsDTO;
import org.correomqtt.business.model.ThemeSettingsDTO;
import org.correomqtt.business.services.BaseUserFileService;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.theme.ThemeProvider;
import org.correomqtt.gui.theme.light.LightThemeProvider;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.spi.ThemeProviderHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsService
extends BaseUserFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsService.class);
    private static final String CONFIG_FILE_NAME = "config.json";
    private static final String CSS_FILE_NAME = "style.css";
    private static final String EX_MSG_PREPARE_CONFIG = "Exception preparing config file.";
    private static final String EX_MSG_WRITE_CONFIG = "Exception writing config file.";
    private ThemeProvider activeThemeProvider;
    private static SettingsService instance = null;
    private ConfigDTO configDTO;

    private SettingsService() {
        try {
            this.prepareFile(CONFIG_FILE_NAME);
        }
        catch (InvalidPathException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onInvalidPath();
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onFileAlreadyExists();
        }
        catch (DirectoryNotEmptyException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        catch (SecurityException | AccessDeniedException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryNotAccessible();
        }
        catch (IOException | UnsupportedOperationException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigPrepareFailure();
        }
        try {
            this.configDTO = (ConfigDTO)new ObjectMapper().readValue(this.getFile(), ConfigDTO.class);
        }
        catch (IOException e) {
            LOGGER.error("Exception parsing config file.", (Throwable)e);
            ConfigDispatcher.getInstance().onInvalidJsonFormat();
        }
    }

    public static synchronized SettingsService getInstance() {
        if (instance == null) {
            instance = new SettingsService();
            return instance;
        }
        return instance;
    }

    private ThemeProvider getActiveTheme() {
        if (this.activeThemeProvider == null) {
            String activeThemeName = this.configDTO.getThemesSettings().getActiveTheme().getName();
            ArrayList<ThemeProviderHook> themes = new ArrayList<ThemeProviderHook>(PluginManager.getInstance().getExtensions(ThemeProviderHook.class));
            this.activeThemeProvider = themes.stream().filter(t -> t.getName().equals(activeThemeName)).findFirst().orElse(new LightThemeProvider());
        }
        return this.activeThemeProvider;
    }

    public List<ConnectionConfigDTO> getConnectionConfigs() {
        return this.configDTO.getConnections();
    }

    public SettingsDTO getSettings() {
        return this.configDTO.getSettings();
    }

    public ThemeSettingsDTO getThemeSettings() {
        return this.configDTO.getThemesSettings();
    }

    public void saveSettings() {
        this.activeThemeProvider = null;
        this.saveDTO();
        this.saveToUserDirectory(CSS_FILE_NAME, this.getActiveTheme().getCss());
        ConfigDispatcher.getInstance().onSettingsUpdated();
    }

    public void saveConnections(List<ConnectionConfigDTO> connections) {
        this.configDTO.setConnections(connections);
        this.saveDTO();
        ConnectionHolder.getInstance().refresh();
        ConfigDispatcher.getInstance().onConnectionsUpdated();
    }

    private void saveDTO() {
        try {
            new ObjectMapper().writeValue(this.getFile(), (Object)this.configDTO);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(EX_MSG_WRITE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        catch (JsonGenerationException | JsonMappingException e) {
            LOGGER.error(EX_MSG_WRITE_CONFIG, e);
            ConfigDispatcher.getInstance().onInvalidJsonFormat();
        }
        catch (IOException e) {
            LOGGER.error(EX_MSG_WRITE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onSavingFailed();
        }
    }

    public String getCssPath() {
        File cssFile = new File(this.getTargetDirectoryPath() + File.separator + CSS_FILE_NAME);
        if (!cssFile.exists()) {
            this.saveToUserDirectory(CSS_FILE_NAME, this.getActiveTheme().getCss());
        }
        if (cssFile.exists()) {
            return cssFile.toURI().toString();
        }
        return null;
    }

    public String getLogPath() {
        return this.getTargetDirectoryPath() + File.separator;
    }

    public String getIconModeCssClass() {
        return this.configDTO.getThemesSettings().getActiveTheme().getIconMode().toString();
    }
}

