/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.cell;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import org.correomqtt.business.services.SettingsService;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.correomqtt.plugin.manager.MessageValidator;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.model.MessageExtensionDTO;
import org.correomqtt.plugin.spi.MessageListHook;
import org.correomqtt.plugin.spi.MessageValidatorHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageViewCell
extends ListCell<MessagePropertiesDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageViewCell.class);
    private static final int MAX_PAYLOAD_LENGTH = 1000;
    private final ListView<MessagePropertiesDTO> listView;
    @FXML
    private Pane mainNode;
    @FXML
    private Label topicLabel;
    @FXML
    private HBox labelBox;
    @FXML
    private Label validLabel;
    @FXML
    private Label invalidLabel;
    @FXML
    private Label retainedLabel;
    @FXML
    private Label qosLabel;
    @FXML
    private Label payloadLabel;
    @FXML
    private Label subscriptionLabel;
    private FXMLLoader loader;
    private MessagePropertiesDTO messageDTO;
    private ContextMenu contextMenu;
    @FXML
    private ResourceBundle resources;

    public MessageViewCell(ListView<MessagePropertiesDTO> listView) {
        this.listView = listView;
    }

    protected void updateItem(MessagePropertiesDTO messageDTO, boolean empty) {
        super.updateItem((Object)messageDTO, empty);
        if (empty || messageDTO == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.loader == null) {
                try {
                    this.loader = new FXMLLoader(MessageViewCell.class.getResource("messageView.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", SettingsService.getInstance().getSettings().getCurrentLocale()));
                    this.loader.setController((Object)this);
                    this.loader.load();
                }
                catch (Exception e) {
                    LOGGER.error("Exception receiving message:", (Throwable)e);
                    this.setText(this.resources.getString("commonRowCreationError"));
                    this.setGraphic(null);
                    return;
                }
            }
            this.mainNode.prefWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20));
            this.setUpMessage(messageDTO);
            this.setText(null);
            this.setGraphic((Node)this.mainNode);
        }
    }

    private void setUpMessage(MessagePropertiesDTO messageDTO) {
        this.topicLabel.getStyleClass().removeAll((Object[])new String[]{"published", "succeeded", "failed"});
        if (messageDTO.getPublishStatus() != null) {
            switch (messageDTO.getPublishStatus()) {
                case PUBLISEHD: {
                    this.topicLabel.getStyleClass().add((Object)"published");
                    break;
                }
                case SUCCEEDED: {
                    this.topicLabel.getStyleClass().add((Object)"succeeded");
                    break;
                }
                case FAILED: {
                    this.topicLabel.getStyleClass().add((Object)"failed");
                }
            }
        }
        this.executeOnCreateMessageEntryExtensions(messageDTO);
        this.validateMessage(messageDTO);
        this.subscriptionLabel.setVisible(false);
        this.subscriptionLabel.setManaged(false);
        this.messageDTO = messageDTO;
        this.topicLabel.setText(messageDTO.getTopic());
        if (messageDTO.getSubscription() != null) {
            this.subscriptionLabel.setVisible(true);
            this.subscriptionLabel.setManaged(true);
            this.subscriptionLabel.setText(messageDTO.getSubscription().getTopic());
        }
        this.retainedLabel.setVisible(messageDTO.isRetained());
        this.retainedLabel.setManaged(messageDTO.isRetained());
        this.qosLabel.setText(messageDTO.getQos().toString());
        String payload = messageDTO.getPayload();
        this.payloadLabel.setText(payload.substring(0, Math.min(payload.length(), 1000)).replace("\n", " ").replace("\r", " ").trim());
    }

    private void executeOnCreateMessageEntryExtensions(MessagePropertiesDTO messageDTO) {
        this.labelBox.getChildren().clear();
        PluginManager.getInstance().getExtensions(MessageListHook.class).forEach(p -> p.onCreateEntry(new MessageExtensionDTO(messageDTO), this.labelBox));
    }

    private void validateMessage(MessagePropertiesDTO messageDTO) {
        this.validLabel.setVisible(false);
        this.validLabel.setManaged(false);
        this.invalidLabel.setVisible(false);
        this.invalidLabel.setManaged(false);
        MessageValidatorHook.Validation validation = MessageValidator.validateMessage(messageDTO.getTopic(), messageDTO.getPayload());
        if (validation != null) {
            this.updateValidatorLabel(this.validLabel, validation.isValid(), validation.getTooltip());
            this.updateValidatorLabel(this.invalidLabel, !validation.isValid(), validation.getTooltip());
        }
    }

    private void updateValidatorLabel(Label label, boolean isVisible, String tooltip) {
        label.setVisible(isVisible);
        label.setManaged(isVisible);
        label.setTooltip(new Tooltip(tooltip));
    }
}

