/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.controller.LoaderResult;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

abstract class BaseConnectionController
extends BaseController {
    private String connectionId;
    private String tabId;

    BaseConnectionController(String connectionId) {
        this.connectionId = connectionId;
    }

    static <C extends BaseController, Z extends Class<C>> LoaderResult<C> load(Z controllerClazz, String fxml, String connectionId) {
        return BaseConnectionController.load(controllerClazz, fxml, () -> (BaseController)controllerClazz.getDeclaredConstructor(String.class).newInstance(connectionId));
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String controllerUUID) {
        this.connectionId = controllerUUID;
    }

    Marker getConnectionMarker() {
        return MarkerFactory.getMarker((String)ConnectionHolder.getInstance().getConfig(this.connectionId).getName());
    }

    public String getTabId() {
        return this.tabId;
    }

    public void setTabId(String tabId) {
        this.tabId = tabId;
    }
}

