/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.File;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.model.Auth;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.CorreoMqttVersion;
import org.correomqtt.business.model.Lwt;
import org.correomqtt.business.model.Proxy;
import org.correomqtt.business.model.Qos;
import org.correomqtt.business.model.TlsSsl;
import org.correomqtt.business.mqtt.CorreoMqttClient;
import org.correomqtt.business.services.SettingsService;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.business.TaskFactory;
import org.correomqtt.gui.cell.ConnectionCell;
import org.correomqtt.gui.cell.GenericCell;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.controller.ConnectionSettingsViewDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.helper.CheckTopicHelper;
import org.correomqtt.gui.model.ConnectionPropertiesDTO;
import org.correomqtt.gui.model.GenericCellModel;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.correomqtt.gui.transformer.ConnectionTransformer;
import org.correomqtt.gui.utils.WindowHelper;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.model.LwtConnectionExtensionDTO;
import org.correomqtt.plugin.spi.LwtSettingsHook;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionSettingsViewController
extends BaseController
implements ConfigObserver,
ConnectionLifecycleObserver,
LwtSettingsHook.OnSettingsChangedListener {
    private static final String TEXT_FIELD = "text-field";
    private static final String TEXT_INPUT = "text-input";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionSettingsViewController.class);
    private static final int CLIENT_ID_MAX_SIZE = 64;
    private final ConnectionSettingsViewDelegate delegate;
    @FXML
    private ListView<ConnectionPropertiesDTO> connectionsListView;
    @FXML
    private TabPane connectionConfigTabPane;
    @FXML
    private TextField nameTextField;
    @FXML
    private TextField urlTextField;
    @FXML
    private TextField portTextField;
    @FXML
    private TextField clientIdTextField;
    @FXML
    private TextField usernameTextField;
    @FXML
    private PasswordField passwordField;
    @FXML
    private CheckBox cleanSessionCheckBox;
    @FXML
    private ComboBox<CorreoMqttVersion> mqttVersionComboBox;
    @FXML
    private Label internalIdLabel;
    @FXML
    private ComboBox<TlsSsl> tlsComboBox;
    @FXML
    private GridPane tlsSslGridPane;
    @FXML
    private TextField sslKeystoreTextField;
    @FXML
    private TextField sslKeystorePasswordTextField;
    @FXML
    private ComboBox<Proxy> proxyComboBox;
    @FXML
    private GridPane proxyGridPane;
    @FXML
    private TextField sshHostTextField;
    @FXML
    private TextField sshPortTextField;
    @FXML
    private TextField localPortTextField;
    @FXML
    private ComboBox<Auth> authComboBox;
    @FXML
    private TextField authUsernameTextField;
    @FXML
    private PasswordField authPasswordField;
    @FXML
    private HBox authKeyfileHBox;
    @FXML
    private TextField authKeyFileTextField;
    @FXML
    private Label dropLabel;
    @FXML
    private Label upLabel;
    @FXML
    private Label downLabel;
    @FXML
    private Button applyButton;
    @FXML
    private Button saveButton;
    @FXML
    private AnchorPane containerAnchorPane;
    @FXML
    private VBox lwtContentVBox;
    @FXML
    private ComboBox<Lwt> lwtComboBox;
    @FXML
    private ComboBox<String> lwtTopicComboBox;
    @FXML
    private ComboBox<Qos> lwtQoSComboBox;
    @FXML
    private HBox lwtPluginControlBox;
    @FXML
    private CheckBox lwtRetainedCheckBox;
    @FXML
    private CodeArea lwtPayloadCodeArea;
    @FXML
    private Pane lwtPayloadPane;
    private static ResourceBundle resources;
    private ConnectionPropertiesDTO activeConnectionConfigDTO;
    private AtomicBoolean dirtyCheckEnabled = new AtomicBoolean(true);
    private boolean dragging;
    Map<String, Integer> waitForDisconnectIds = new HashMap<String, Integer>();

    public ConnectionSettingsViewController(ConnectionSettingsViewDelegate delegate) {
        this.delegate = delegate;
        ConfigDispatcher.getInstance().addObserver(this);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
    }

    public static LoaderResult<ConnectionSettingsViewController> load(ConnectionSettingsViewDelegate delegate) {
        return ConnectionSettingsViewController.load(ConnectionSettingsViewController.class, "connectionSettingsView.fxml", () -> new ConnectionSettingsViewController(delegate));
    }

    public static void showAsDialog(ConnectionSettingsViewDelegate delegate) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.CONNECTION_SETTINGS);
        if (WindowHelper.focusWindowIfAlreadyThere(properties)) {
            return;
        }
        LoaderResult<ConnectionSettingsViewController> result = ConnectionSettingsViewController.load(delegate);
        resources = result.getResourceBundle();
        ConnectionSettingsViewController.showAsDialog(result, resources.getString("connectionSettingsViewControllerTitle"), properties, false, false, null, (EventHandler<KeyEvent>)((EventHandler)event -> ((ConnectionSettingsViewController)result.getController()).keyHandling((KeyEvent)event)));
    }

    @FXML
    public void initialize() {
        this.containerAnchorPane.getStyleClass().add((Object)SettingsService.getInstance().getIconModeCssClass());
        this.connectionConfigTabPane.setDisable(true);
        this.loadConnectionListFromBackground();
        this.mqttVersionComboBox.setItems(FXCollections.observableArrayList((Object[])CorreoMqttVersion.values()));
        this.mqttVersionComboBox.setCellFactory(GenericCell::new);
        this.mqttVersionComboBox.setConverter(this.getStringConverter());
        this.tlsComboBox.setItems(FXCollections.observableArrayList((Object[])TlsSsl.values()));
        this.tlsComboBox.setCellFactory(GenericCell::new);
        this.tlsComboBox.setConverter(this.getStringConverter());
        this.proxyComboBox.setItems(FXCollections.observableArrayList((Object[])Proxy.values()));
        this.proxyComboBox.setCellFactory(GenericCell::new);
        this.proxyComboBox.setConverter(this.getStringConverter());
        this.authComboBox.setItems(FXCollections.observableArrayList((Object[])Auth.values()));
        this.authComboBox.setCellFactory(GenericCell::new);
        this.authComboBox.setConverter(this.getStringConverter());
        this.lwtComboBox.setItems(FXCollections.observableArrayList((Object[])Lwt.values()));
        this.lwtComboBox.setCellFactory(GenericCell::new);
        this.lwtComboBox.setConverter(this.getStringConverter());
        this.lwtQoSComboBox.setItems(FXCollections.observableArrayList((Object[])Qos.values()));
        this.lwtPayloadPane.getChildren().add((Object)new VirtualizedScrollPane((Node)this.lwtPayloadCodeArea));
        this.lwtPayloadCodeArea.prefWidthProperty().bind((ObservableValue)this.lwtPayloadPane.widthProperty());
        this.lwtPayloadCodeArea.prefHeightProperty().bind((ObservableValue)this.lwtPayloadPane.heightProperty());
        PluginManager.getInstance().getExtensions(LwtSettingsHook.class).forEach(p -> p.onAddItemsToLwtSettingsBox(this, this.lwtPluginControlBox));
        this.connectionsListView.setCellFactory(this::createCell);
        this.saveButton.setDisable(true);
        this.applyButton.setDisable(true);
        this.dropLabel.setDisable(true);
        this.upLabel.setDisable(true);
        this.downLabel.setDisable(true);
        this.nameTextField.lengthProperty().addListener((observable, oldValue, newValue) -> this.checkName(this.nameTextField, false));
        this.urlTextField.lengthProperty().addListener((observable, oldValue, newValue) -> this.checkUrl(this.urlTextField, false));
        this.portTextField.lengthProperty().addListener((observable, oldValue, newValue) -> this.checkPort(this.portTextField, false));
        this.clientIdTextField.lengthProperty().addListener((observable, oldValue, newValue) -> this.checkClientID(this.clientIdTextField, false));
        this.nameTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.urlTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.portTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.clientIdTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.passwordField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.usernameTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.cleanSessionCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.mqttVersionComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.tlsComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.setDirty(true);
            if (newValue.equals(TlsSsl.OFF)) {
                this.tlsSslGridPane.setDisable(true);
            } else if (newValue.equals(TlsSsl.KEYSTORE)) {
                this.tlsSslGridPane.setDisable(false);
            }
        });
        this.sslKeystoreTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.sslKeystorePasswordTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.proxyComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.setDirty(true);
            if (newValue.equals(Proxy.OFF)) {
                this.proxyGridPane.setDisable(true);
            } else if (newValue.equals(Proxy.SSH)) {
                this.proxyGridPane.setDisable(false);
            }
        });
        this.sshHostTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.sshPortTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.localPortTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.authComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.setDirty(true);
            if (newValue.equals(Auth.OFF)) {
                this.authUsernameTextField.setDisable(true);
                this.authPasswordField.setDisable(true);
                this.authKeyfileHBox.setDisable(true);
            } else if (newValue.equals(Auth.PASSWORD)) {
                this.authUsernameTextField.setDisable(false);
                this.authPasswordField.setDisable(false);
                this.authKeyfileHBox.setDisable(true);
            } else if (newValue.equals(Auth.KEYFILE)) {
                this.authUsernameTextField.setDisable(false);
                this.authPasswordField.setDisable(true);
                this.authKeyfileHBox.setDisable(false);
            }
        });
        this.authUsernameTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.authPasswordField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.authKeyFileTextField.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.lwtComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.setDirty(true);
            if (newValue.equals(Lwt.OFF)) {
                this.lwtContentVBox.setDisable(true);
            } else if (newValue.equals(Lwt.ON)) {
                this.lwtContentVBox.setDisable(false);
            }
        });
        this.lwtTopicComboBox.getEditor().lengthProperty().addListener((observable, oldValue, newValue) -> {
            this.setDirty(true);
            CheckTopicHelper.checkPublishTopic(this.lwtTopicComboBox, false);
        });
        this.lwtQoSComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.lwtRetainedCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.lwtPayloadCodeArea.textProperty().addListener((observable, oldValue, newValue) -> this.setDirty(true));
        this.internalIdLabel.setText("");
    }

    private <T extends GenericCellModel> StringConverter<T> getStringConverter() {
        return new StringConverter<T>(){

            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                String translationKey = object.getLabelTranslationKey();
                if (translationKey != null) {
                    return resources.getString(translationKey);
                }
                return object.toString();
            }

            public T fromString(String string) {
                return null;
            }
        };
    }

    private ListCell<ConnectionPropertiesDTO> createCell(ListView<ConnectionPropertiesDTO> connectionListView) {
        ConnectionCell cell = new ConnectionCell(connectionListView);
        cell.selectedProperty().addListener((observable, oldValue, newValue) -> {
            ConnectionPropertiesDTO selectedItem = (ConnectionPropertiesDTO)this.connectionsListView.getSelectionModel().getSelectedItem();
            if (selectedItem == this.activeConnectionConfigDTO) {
                return;
            }
            if (!this.dragging && this.checkDirty()) {
                this.showConnection(selectedItem);
                this.connectionsListView.getSelectionModel().select((Object)this.activeConnectionConfigDTO);
            } else {
                this.connectionsListView.getSelectionModel().select((Object)this.activeConnectionConfigDTO);
            }
        });
        this.setOnDragDetected(cell);
        this.setOnDragOver(cell);
        this.setOnDragEntered(cell);
        this.setOnDragDropped(cell);
        cell.setOnDragDone(Event::consume);
        return cell;
    }

    private void setOnDragDetected(ConnectionCell cell) {
        cell.setOnDragDetected(event -> {
            if (cell.getItem() == null) {
                return;
            }
            if (!this.checkDirty()) {
                return;
            }
            this.dragging = true;
            Dragboard dragboard = cell.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            ClipboardContent content = new ClipboardContent();
            content.putString(String.valueOf(this.connectionsListView.getSelectionModel().getSelectedIndex()));
            dragboard.setContent((Map)content);
            event.consume();
        });
    }

    private void setOnDragOver(ConnectionCell cell) {
        cell.setOnDragOver(event -> {
            if (event.getDragboard().hasString()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            event.consume();
        });
    }

    private void setOnDragEntered(ConnectionCell cell) {
        cell.setOnDragEntered(event -> {
            Dragboard db;
            if (event.getDragboard().hasString() && (db = event.getDragboard()).hasString()) {
                ConnectionPropertiesDTO temp;
                int i;
                int thisIdx;
                ObservableList items = cell.getListView().getItems();
                int draggedIdx = this.connectionsListView.getSelectionModel().getSelectedIndex();
                if (draggedIdx > (thisIdx = items.indexOf(cell.getItem())) && draggedIdx > -1 && thisIdx > -1) {
                    for (i = draggedIdx; i > thisIdx; --i) {
                        temp = (ConnectionPropertiesDTO)this.connectionsListView.getItems().get(i);
                        this.connectionsListView.getItems().set(i, (Object)((ConnectionPropertiesDTO)this.connectionsListView.getItems().get(i - 1)));
                        this.connectionsListView.getItems().set(i - 1, (Object)temp);
                    }
                }
                if (draggedIdx < thisIdx && draggedIdx > -1 && thisIdx > -1) {
                    for (i = draggedIdx; i < thisIdx; ++i) {
                        temp = (ConnectionPropertiesDTO)this.connectionsListView.getItems().get(i);
                        this.connectionsListView.getItems().set(i, (Object)((ConnectionPropertiesDTO)this.connectionsListView.getItems().get(i + 1)));
                        this.connectionsListView.getItems().set(i + 1, (Object)temp);
                    }
                }
                this.connectionsListView.getSelectionModel().select(thisIdx);
            }
        });
    }

    private void setOnDragDropped(ConnectionCell cell) {
        cell.setOnDragDropped(event -> {
            event.setDropCompleted(true);
            this.dragging = false;
            this.saveConnection();
            this.setUpDownLabel();
        });
    }

    private void loadConnectionListFromBackground() {
        ObservableList list = FXCollections.observableArrayList(ConnectionPropertiesDTO.extractor());
        ConnectionHolder.getInstance().getSortedConnections().forEach(c -> list.add((Object)ConnectionTransformer.dtoToProps(c)));
        this.connectionsListView.setItems(list);
        this.executeOnLoadSettingsExtensions();
        LOGGER.debug("Loading connection list from background");
    }

    private void executeOnLoadSettingsExtensions() {
        this.connectionsListView.getItems().forEach(c -> {
            this.decodeLwtPayload((ConnectionPropertiesDTO)c);
            LwtConnectionExtensionDTO connectionExtensionDTO = new LwtConnectionExtensionDTO((ConnectionPropertiesDTO)c);
            for (LwtSettingsHook p : PluginManager.getInstance().getExtensions(LwtSettingsHook.class)) {
                connectionExtensionDTO = p.onLoadConnection(connectionExtensionDTO);
            }
            connectionExtensionDTO.merge((ConnectionPropertiesDTO)c);
        });
    }

    private void decodeLwtPayload(ConnectionPropertiesDTO connectionPropertiesDTO) {
        String lwtPayload = connectionPropertiesDTO.getLwtPayload();
        if (lwtPayload != null) {
            connectionPropertiesDTO.getLwtPayloadProperty().set((Object)new String(Base64.getDecoder().decode(lwtPayload)));
        }
    }

    private boolean checkDirty() {
        if (this.activeConnectionConfigDTO != null && this.activeConnectionConfigDTO.isDirty()) {
            if (this.confirmUnsavedConnectionSync()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unsaved connection status confirmed: {}", (Object)this.activeConnectionConfigDTO.getId());
                }
                return this.saveConnection();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Discarding unsaved changes: {}", (Object)this.activeConnectionConfigDTO.getId());
            }
            if (this.activeConnectionConfigDTO.isUnpersisted()) {
                this.connectionsListView.getItems().remove((Object)this.activeConnectionConfigDTO);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Removing connection: {}", (Object)this.activeConnectionConfigDTO.getId());
                }
            } else {
                this.activeConnectionConfigDTO.getDirtyProperty().set(false);
                this.showConnection(this.activeConnectionConfigDTO);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Dirty Property set to false: {}", (Object)this.activeConnectionConfigDTO.getId());
                }
            }
        }
        return true;
    }

    @FXML
    public void onAddClicked() {
        LOGGER.debug("Add new connection clicked");
        if (this.checkDirty()) {
            this.addConnection();
        }
    }

    @FXML
    public void onRemoveClicked() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Remove connection clicked: {}", (Object)this.activeConnectionConfigDTO.getId());
        }
        if (this.checkDirty()) {
            this.dropConnection();
        }
    }

    @FXML
    public void onCancelClicked() {
        ConnectionPropertiesDTO config = (ConnectionPropertiesDTO)this.connectionsListView.getSelectionModel().getSelectedItem();
        if (config != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cancel editing clicked: {}", (Object)this.activeConnectionConfigDTO.getId());
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cancel editing clicked without selected connection");
        }
        if (config != null && config.isDirty()) {
            if (this.confirmUnsavedConnectionSync()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unsaved connection status confirmed: {}", (Object)this.activeConnectionConfigDTO.getId());
                }
                if (!this.saveConnection()) {
                    return;
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Discarding unsaved changes: {}", (Object)this.activeConnectionConfigDTO.getId());
                }
                this.setDirty(false);
            }
        }
        this.closeDialog();
    }

    @FXML
    public void onApplyClicked() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Apply changes clicked: {}", (Object)this.activeConnectionConfigDTO.getId());
        }
        if (this.saveConnection()) {
            this.showConnection(this.activeConnectionConfigDTO);
        }
    }

    @FXML
    public void onSaveClicked() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Save changes clicked: {}", (Object)this.activeConnectionConfigDTO.getId());
        }
        if (this.saveConnection()) {
            this.closeDialog();
        }
    }

    private boolean doChecks() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Do form checks for connection: {}", (Object)this.activeConnectionConfigDTO.getId());
        }
        boolean checksPassed = !this.checkName(this.nameTextField, true);
        checksPassed |= !this.checkUrl(this.urlTextField, true);
        checksPassed |= !this.checkPort(this.portTextField, true);
        checksPassed |= !this.checkClientID(this.clientIdTextField, true);
        if (((Lwt)this.lwtComboBox.getSelectionModel().getSelectedItem()).equals(Lwt.ON)) {
            checksPassed |= !CheckTopicHelper.checkPublishTopic(this.lwtTopicComboBox, true);
        }
        return !checksPassed;
    }

    private void closeDialog() {
        Stage stage = (Stage)this.saveButton.getScene().getWindow();
        stage.close();
    }

    private void keyHandling(KeyEvent event) {
        if (KeyCode.ESCAPE == event.getCode()) {
            this.closeDialog();
        }
    }

    private void setUpDownLabel() {
        if (this.connectionsListView.getSelectionModel().getSelectedIndex() == 0) {
            this.upLabel.setDisable(true);
        }
        if (this.connectionsListView.getSelectionModel().getSelectedIndex() == this.connectionsListView.getItems().size() - 1) {
            this.downLabel.setDisable(true);
        }
    }

    private void showConnection(ConnectionPropertiesDTO config) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Show connection: {}", (Object)config.getId());
        }
        this.dirtyCheckEnabled.set(false);
        this.activeConnectionConfigDTO = config;
        this.connectionConfigTabPane.setDisable(false);
        this.saveButton.setDisable(false);
        this.applyButton.setDisable(false);
        this.dropLabel.setDisable(false);
        this.upLabel.setDisable(false);
        this.downLabel.setDisable(false);
        this.setUpDownLabel();
        if (this.activeConnectionConfigDTO != null) {
            this.executeOnShowConnectionExtensions();
            this.nameTextField.setText(this.activeConnectionConfigDTO.getName());
            this.urlTextField.setText(this.activeConnectionConfigDTO.getUrl());
            this.portTextField.setText(Integer.toString(this.activeConnectionConfigDTO.getPort()));
            this.clientIdTextField.setText(this.activeConnectionConfigDTO.getClientId());
            this.usernameTextField.setText(this.activeConnectionConfigDTO.getUsername());
            this.passwordField.setText(this.activeConnectionConfigDTO.getPassword());
            this.cleanSessionCheckBox.setSelected(this.activeConnectionConfigDTO.isCleanSession());
            this.mqttVersionComboBox.getSelectionModel().select((Object)this.activeConnectionConfigDTO.getMqttVersion());
            this.tlsSslGridPane.setDisable(((TlsSsl)this.activeConnectionConfigDTO.getSslProperty().getValue()).equals(TlsSsl.OFF));
            this.tlsComboBox.getSelectionModel().select((Object)this.activeConnectionConfigDTO.getSsl());
            this.sslKeystoreTextField.setText(this.activeConnectionConfigDTO.getSslKeystore());
            this.sslKeystorePasswordTextField.setText(this.activeConnectionConfigDTO.getSslKeystorePassword());
            this.proxyGridPane.setDisable(((Proxy)this.activeConnectionConfigDTO.getProxyProperty().getValue()).equals(Proxy.OFF));
            this.proxyComboBox.getSelectionModel().select((Object)this.activeConnectionConfigDTO.getProxy());
            this.sshHostTextField.setText(this.activeConnectionConfigDTO.getSshHost());
            this.sshPortTextField.setText(Integer.toString(this.activeConnectionConfigDTO.getSshPort()));
            this.localPortTextField.setText(Integer.toString(this.activeConnectionConfigDTO.getLocalPort()));
            if (this.activeConnectionConfigDTO.getAuth().equals(Auth.OFF)) {
                this.authUsernameTextField.setDisable(true);
                this.authPasswordField.setDisable(true);
                this.authKeyfileHBox.setDisable(true);
            } else if (this.activeConnectionConfigDTO.getAuth().equals(Auth.PASSWORD)) {
                this.authUsernameTextField.setDisable(false);
                this.authPasswordField.setDisable(false);
                this.authKeyfileHBox.setDisable(true);
            } else if (this.activeConnectionConfigDTO.getAuth().equals(Auth.KEYFILE)) {
                this.authUsernameTextField.setDisable(false);
                this.authPasswordField.setDisable(true);
                this.authKeyfileHBox.setDisable(false);
            }
            this.authComboBox.getSelectionModel().select((Object)this.activeConnectionConfigDTO.getAuth());
            this.authUsernameTextField.setText(this.activeConnectionConfigDTO.getAuthUsername());
            this.authPasswordField.setText(this.activeConnectionConfigDTO.getAuthPassword());
            this.authKeyFileTextField.setText(this.activeConnectionConfigDTO.getAuthKeyfile());
            this.lwtContentVBox.setDisable(this.activeConnectionConfigDTO.getLwt().equals(Lwt.OFF));
            this.lwtComboBox.getSelectionModel().select((Object)this.activeConnectionConfigDTO.getLwt());
            this.lwtTopicComboBox.getEditor().setText(this.activeConnectionConfigDTO.getLwtTopic());
            this.lwtQoSComboBox.getSelectionModel().select((Object)this.activeConnectionConfigDTO.getLwtQos());
            this.lwtRetainedCheckBox.setSelected(this.activeConnectionConfigDTO.isLwtRetained());
            if (this.activeConnectionConfigDTO.getLwtPayload() != null) {
                this.lwtPayloadCodeArea.replaceText(this.activeConnectionConfigDTO.getLwtPayload());
            }
            this.internalIdLabel.setText(resources.getString("connectionSettingsViewInternalIdLabel") + ": " + this.activeConnectionConfigDTO.getId());
            this.activeConnectionConfigDTO.getDirtyProperty().set(false);
            this.applyButton.setDisable(true);
            this.saveButton.setDisable(true);
        }
        this.dirtyCheckEnabled.set(true);
    }

    private void executeOnShowConnectionExtensions() {
        LwtConnectionExtensionDTO lwtConnectionExtensionDTO = new LwtConnectionExtensionDTO(this.activeConnectionConfigDTO);
        for (LwtSettingsHook p : PluginManager.getInstance().getExtensions(LwtSettingsHook.class)) {
            lwtConnectionExtensionDTO = p.onShowConnection(lwtConnectionExtensionDTO);
        }
        this.activeConnectionConfigDTO = lwtConnectionExtensionDTO.merge(this.activeConnectionConfigDTO);
    }

    @Override
    public void setDirty(boolean dirty) {
        if (this.dirtyCheckEnabled.get()) {
            this.activeConnectionConfigDTO.getDirtyProperty().set(dirty);
            this.applyButton.setDisable(!dirty);
            this.saveButton.setDisable(!dirty);
            this.upLabel.setDisable(dirty);
            this.downLabel.setDisable(dirty);
        }
    }

    @FXML
    public void onGenerateClientIdClick() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Generating Client ID for connection clicked: {}", (Object)this.activeConnectionConfigDTO.getId());
        }
        this.clientIdTextField.setText(UUID.randomUUID().toString());
    }

    private void addConnection() {
        ConnectionPropertiesDTO newConfig = ConnectionTransformer.dtoToProps(ConnectionConfigDTO.builder().id(UUID.randomUUID().toString()).name(resources.getString("connectionSettingsViewControllerNewConnectionName")).build());
        newConfig.getUnpersistedProperty().set(true);
        newConfig.getDirtyProperty().set(true);
        this.connectionsListView.getItems().add((Object)newConfig);
        this.connectionsListView.getSelectionModel().select((Object)newConfig);
        newConfig.getUnpersistedProperty().set(true);
        this.showConnection(newConfig);
        this.setDirty(true);
        this.nameTextField.requestFocus();
    }

    private void dropConnection() {
        ConnectionPropertiesDTO selectedItem = (ConnectionPropertiesDTO)this.connectionsListView.getSelectionModel().getSelectedItem();
        boolean confirmed = AlertHelper.confirm(resources.getString("connectionSettingsViewControllerDeleteTitle"), resources.getString("connectionSettingsViewControllerDeleteHeader") + "? (" + selectedItem + ")", null, resources.getString("commonNoButton"), resources.getString("commonYesButton"));
        int selectedIndex = this.connectionsListView.getSelectionModel().getSelectedIndex();
        if (confirmed) {
            LOGGER.info("Disconnect connection selected");
            CorreoMqttClient client = ConnectionHolder.getInstance().getClient(selectedItem.getId());
            if (client != null) {
                LOGGER.info("Connection is still connected");
                confirmed = AlertHelper.confirm(resources.getString("connectionSettingsViewControllerStillInUseTitle"), resources.getString("connectionSettingsViewControllerStillInUseHeader"), null, resources.getString("commonNoButton"), resources.getString("commonYesButton"));
                if (confirmed) {
                    LOGGER.info("Disconnect");
                    TaskFactory.disconnect(selectedItem.getId());
                    this.waitForDisconnectIds.put(selectedItem.getId(), selectedIndex);
                }
            } else {
                this.removeConnectionAndSave(selectedItem, selectedIndex);
            }
        }
    }

    private void removeConnectionAndSave(ConnectionPropertiesDTO selectedItem, int selectedIndex) {
        this.connectionConfigTabPane.setDisable(true);
        this.connectionsListView.getItems().remove((Object)selectedItem);
        SettingsService.getInstance().saveConnections(ConnectionTransformer.propsListToDtoList((ObservableList<ConnectionPropertiesDTO>)this.connectionsListView.getItems()));
        if (selectedIndex != 0 && --selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (this.connectionsListView.getItems().size() > selectedIndex) {
            this.connectionsListView.getSelectionModel().select(selectedIndex);
            this.showConnection((ConnectionPropertiesDTO)this.connectionsListView.getItems().get(selectedIndex));
        } else {
            this.clearConnectionsForm();
            this.applyButton.setDisable(true);
            this.saveButton.setDisable(true);
            this.dropLabel.setDisable(true);
            this.upLabel.setDisable(true);
            this.downLabel.setDisable(true);
        }
    }

    private boolean saveConnection() {
        if (this.doChecks()) {
            this.activeConnectionConfigDTO.getNameProperty().set((Object)this.nameTextField.getText());
            this.activeConnectionConfigDTO.getUrlProperty().set((Object)this.urlTextField.getText());
            this.activeConnectionConfigDTO.getPortProperty().set(Integer.parseInt(this.portTextField.getText()));
            this.activeConnectionConfigDTO.getClientIdProperty().set((Object)this.clientIdTextField.getText());
            this.activeConnectionConfigDTO.getUsernameProperty().set((Object)this.usernameTextField.getText());
            this.activeConnectionConfigDTO.getPasswordProperty().set((Object)this.passwordField.getText());
            this.activeConnectionConfigDTO.getCleanSessionProperty().set(this.cleanSessionCheckBox.isSelected());
            this.activeConnectionConfigDTO.getMqttVersionProperty().setValue((Object)((CorreoMqttVersion)this.mqttVersionComboBox.getSelectionModel().getSelectedItem()));
            this.activeConnectionConfigDTO.getSslProperty().setValue((Object)((TlsSsl)this.tlsComboBox.getSelectionModel().getSelectedItem()));
            this.activeConnectionConfigDTO.getSslKeystoreProperty().set((Object)this.sslKeystoreTextField.getText());
            this.activeConnectionConfigDTO.getSslKeystorePasswordProperty().set((Object)this.sslKeystorePasswordTextField.getText());
            this.activeConnectionConfigDTO.getProxyProperty().setValue((Object)((Proxy)this.proxyComboBox.getSelectionModel().getSelectedItem()));
            this.activeConnectionConfigDTO.getSshHostProperty().set((Object)this.sshHostTextField.getText());
            this.activeConnectionConfigDTO.getSshPortProperty().set(Integer.parseInt(this.sshPortTextField.getText()));
            this.activeConnectionConfigDTO.getLocalPortProperty().set(Integer.parseInt(this.localPortTextField.getText()));
            if (((Auth)this.authComboBox.getSelectionModel().getSelectedItem()).equals(Auth.PASSWORD)) {
                this.activeConnectionConfigDTO.getAuthProperty().setValue((Object)Auth.PASSWORD);
            } else if (((Auth)this.authComboBox.getSelectionModel().getSelectedItem()).equals(Auth.KEYFILE)) {
                this.activeConnectionConfigDTO.getAuthProperty().setValue((Object)Auth.KEYFILE);
            } else {
                this.activeConnectionConfigDTO.getAuthProperty().setValue((Object)Auth.OFF);
            }
            this.activeConnectionConfigDTO.getAuthUsernameProperty().set((Object)this.authUsernameTextField.getText());
            this.activeConnectionConfigDTO.getAuthPasswordProperty().set((Object)this.authPasswordField.getText());
            this.activeConnectionConfigDTO.getAuthKeyfileProperty().set((Object)this.authKeyFileTextField.getText());
            this.activeConnectionConfigDTO.getLwtProperty().setValue((Object)((Lwt)this.lwtComboBox.getSelectionModel().getSelectedItem()));
            this.activeConnectionConfigDTO.getLwtTopicProperty().set((Object)this.lwtTopicComboBox.getEditor().getText());
            this.activeConnectionConfigDTO.getLwtQoSProperty().setValue((Object)((Qos)((Object)this.lwtQoSComboBox.getSelectionModel().getSelectedItem())));
            this.activeConnectionConfigDTO.getLwtRetainedProperty().set(this.lwtRetainedCheckBox.isSelected());
            this.activeConnectionConfigDTO.getLwtPayloadProperty().set((Object)this.lwtPayloadCodeArea.getText());
            this.activeConnectionConfigDTO = this.executeOnSaveSettingsExtensions(this.activeConnectionConfigDTO);
            this.executeOnUnloadSettingsExtensions();
            SettingsService.getInstance().saveConnections(ConnectionTransformer.propsListToDtoList((ObservableList<ConnectionPropertiesDTO>)this.connectionsListView.getItems()));
            this.saveButton.setDisable(false);
            this.applyButton.setDisable(false);
            this.dropLabel.setDisable(false);
            this.upLabel.setDisable(false);
            this.downLabel.setDisable(false);
            this.activeConnectionConfigDTO.getDirtyProperty().set(false);
            this.activeConnectionConfigDTO.getUnpersistedProperty().set(false);
            this.executeOnLoadSettingsExtensions();
            return true;
        }
        return false;
    }

    private ConnectionPropertiesDTO executeOnSaveSettingsExtensions(ConnectionPropertiesDTO activeConnectionConfigDTO) {
        LwtConnectionExtensionDTO activeExtensionConnectionConfigDTO = new LwtConnectionExtensionDTO(activeConnectionConfigDTO);
        for (LwtSettingsHook p : PluginManager.getInstance().getExtensions(LwtSettingsHook.class)) {
            activeExtensionConnectionConfigDTO = p.onSaveConnection(activeExtensionConnectionConfigDTO);
        }
        return activeExtensionConnectionConfigDTO.merge(activeConnectionConfigDTO);
    }

    private void executeOnUnloadSettingsExtensions() {
        this.connectionsListView.getItems().forEach(c -> {
            LwtConnectionExtensionDTO activeExtensionConnectionConfigDTO = new LwtConnectionExtensionDTO((ConnectionPropertiesDTO)c);
            for (LwtSettingsHook p : PluginManager.getInstance().getExtensions(LwtSettingsHook.class)) {
                activeExtensionConnectionConfigDTO = p.onUnloadConnection(activeExtensionConnectionConfigDTO);
            }
            activeExtensionConnectionConfigDTO.merge((ConnectionPropertiesDTO)c);
            this.encodeLwtPayload((ConnectionPropertiesDTO)c);
        });
    }

    private void encodeLwtPayload(ConnectionPropertiesDTO c) {
        String lwtPayload = c.getLwtPayload();
        if (lwtPayload != null) {
            c.getLwtPayloadProperty().set((Object)Base64.getEncoder().encodeToString(lwtPayload.getBytes()));
        }
    }

    private boolean checkName(TextField textField, boolean save) {
        if (!this.checkRequired(textField)) {
            this.setError(textField, save, resources.getString("validationNameIsEmpty"));
            return false;
        }
        for (ConnectionPropertiesDTO connectionConfigDTO : this.connectionsListView.getItems()) {
            if (connectionConfigDTO == this.activeConnectionConfigDTO || !connectionConfigDTO.getName().equals(this.nameTextField.getText())) continue;
            this.setError(textField, save, resources.getString("validationNameAlreadyUsed"));
            return false;
        }
        if (textField.getText().length() > 32) {
            this.setError(textField, save, resources.getString("validationNameIsTooLong"));
            return false;
        }
        this.nameTextField.getStyleClass().clear();
        this.nameTextField.getStyleClass().addAll((Object[])new String[]{TEXT_FIELD, TEXT_INPUT});
        return true;
    }

    private boolean checkUrl(TextField textField, boolean save) {
        if (!this.checkRequired(textField)) {
            this.setError(textField, save, resources.getString("validationConnectionIsEmpty"));
            return false;
        }
        this.urlTextField.getStyleClass().clear();
        this.urlTextField.getStyleClass().addAll((Object[])new String[]{TEXT_FIELD, TEXT_INPUT});
        return true;
    }

    private boolean checkPort(TextField textField, boolean save) {
        if (!this.checkRequired(textField)) {
            this.setError(textField, save, resources.getString("validationPortIsEmpty"));
            return false;
        }
        if (!textField.getText().matches("-?\\d+") || textField.getText().length() > 5) {
            this.setError(textField, save, resources.getString("validationInvalidPort"));
            return false;
        }
        this.portTextField.getStyleClass().clear();
        this.portTextField.getStyleClass().addAll((Object[])new String[]{TEXT_FIELD, TEXT_INPUT});
        return true;
    }

    private boolean checkClientID(TextField textField, boolean save) {
        if (!this.checkRequired(textField)) {
            this.setError(textField, save, resources.getString("validationClientIdIsEmpty"));
            return false;
        }
        if (textField.getText().length() > 64) {
            this.setError(textField, save, resources.getString("validationClientIdIsTooLong"));
            return false;
        }
        this.clientIdTextField.getStyleClass().clear();
        this.clientIdTextField.getStyleClass().addAll((Object[])new String[]{TEXT_FIELD, TEXT_INPUT});
        return true;
    }

    private void setError(TextField textField, boolean save, String tooltipText) {
        if (save) {
            textField.getStyleClass().add((Object)"errorOnSave");
        }
        textField.setTooltip(new Tooltip(tooltipText));
        textField.getStyleClass().add((Object)"exclamationCircleSolid");
    }

    private boolean checkRequired(TextField textField) {
        return textField.getText() != null && !textField.getText().isEmpty();
    }

    private void clearConnectionsForm() {
        LOGGER.debug("Clearing connections form");
        this.nameTextField.clear();
        this.urlTextField.clear();
        this.portTextField.setText(null);
        this.clientIdTextField.clear();
        this.usernameTextField.clear();
        this.passwordField.clear();
        this.sslKeystoreTextField.clear();
        this.sslKeystorePasswordTextField.clear();
        this.internalIdLabel.setText("");
        this.nameTextField.getStyleClass().removeAll((Object[])new String[]{"emptyError"});
        this.nameTextField.getStyleClass().removeAll((Object[])new String[]{"exclamationCircleSolid"});
        this.urlTextField.getStyleClass().removeAll((Object[])new String[]{"emptyError"});
        this.urlTextField.getStyleClass().removeAll((Object[])new String[]{"exclamationCircleSolid"});
        this.portTextField.getStyleClass().removeAll((Object[])new String[]{"emptyError"});
        this.portTextField.getStyleClass().removeAll((Object[])new String[]{"exclamationCircleSolid"});
        this.clientIdTextField.getStyleClass().removeAll((Object[])new String[]{"emptyError"});
        this.clientIdTextField.getStyleClass().removeAll((Object[])new String[]{"exclamationCircleSolid"});
    }

    private boolean confirmUnsavedConnectionSync() {
        boolean confirmed = AlertHelper.confirm(resources.getString("connectionSettingsViewControllerUnsavedTitle"), resources.getString("connectionSettingsViewControllerUnsavedHeader"), resources.getString("connectionSettingsViewControllerUnsavedContent"), resources.getString("commonSaveButton"), resources.getString("commonDiscardButton"));
        return confirmed;
    }

    @FXML
    private void selectKeystore() {
        FileChooser fileChooser = new FileChooser();
        File selectedFile = fileChooser.showOpenDialog(this.containerAnchorPane.getScene().getWindow());
        this.sslKeystoreTextField.setText(selectedFile.toString());
    }

    @FXML
    private void selectKeyfile() {
        FileChooser fileChooser = new FileChooser();
        File selectedFile = fileChooser.showOpenDialog(this.containerAnchorPane.getScene().getWindow());
        this.authKeyFileTextField.setText(selectedFile.toString());
    }

    @FXML
    private void moveConnectionUp() {
        int currentIndex = this.connectionsListView.getSelectionModel().getSelectedIndex();
        ConnectionPropertiesDTO previous = (ConnectionPropertiesDTO)this.connectionsListView.getItems().get(currentIndex - 1);
        ConnectionPropertiesDTO current = (ConnectionPropertiesDTO)this.connectionsListView.getItems().get(currentIndex);
        this.connectionsListView.getItems().set(currentIndex - 1, (Object)current);
        this.connectionsListView.getItems().set(currentIndex, (Object)previous);
        this.connectionsListView.getSelectionModel().select((Object)current);
        this.saveConnection();
        this.showConnection(current);
    }

    @FXML
    private void moveConnectionDown() {
        int currentIndex = this.connectionsListView.getSelectionModel().getSelectedIndex();
        ConnectionPropertiesDTO next = (ConnectionPropertiesDTO)this.connectionsListView.getItems().get(currentIndex + 1);
        ConnectionPropertiesDTO current = (ConnectionPropertiesDTO)this.connectionsListView.getItems().get(currentIndex);
        this.connectionsListView.getItems().set(currentIndex + 1, (Object)current);
        this.connectionsListView.getItems().set(currentIndex, (Object)next);
        this.connectionsListView.getSelectionModel().select((Object)current);
        this.saveConnection();
        this.showConnection(current);
    }

    @Override
    public void onConfigDirectoryEmpty() {
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
    }

    @Override
    public void onAppDataNull() {
    }

    @Override
    public void onUserHomeNull() {
    }

    @Override
    public void onFileAlreadyExists() {
    }

    @Override
    public void onInvalidPath() {
    }

    @Override
    public void onInvalidJsonFormat() {
    }

    @Override
    public void onSavingFailed() {
    }

    @Override
    public void onSettingsUpdated() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated settings in connection settings view controller");
        }
    }

    @Override
    public void onConnectionsUpdated() {
    }

    @Override
    public void onConfigPrepareFailed() {
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
        if (this.waitForDisconnectIds.get(connectionId) != null) {
            this.delegate.closeTab(((ConnectionPropertiesDTO)this.connectionsListView.getItems().get(this.waitForDisconnectIds.get(connectionId).intValue())).getName());
            this.removeConnectionAndSave((ConnectionPropertiesDTO)this.connectionsListView.getItems().get(this.waitForDisconnectIds.get(connectionId).intValue()), this.waitForDisconnectIds.get(connectionId));
            this.waitForDisconnectIds.remove(connectionId);
        }
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onConnectRunning() {
    }

    @Override
    public void onConnectionFailed(Throwable message) {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onDisconnect() {
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onConnectionReconnected() {
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }

    @Override
    public String getConnectionId() {
        return null;
    }
}

