/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.dispatcher.PersistSubscriptionHistoryDispatcher;
import org.correomqtt.business.dispatcher.PersistSubscriptionHistoryObserver;
import org.correomqtt.business.dispatcher.ShortcutDispatcher;
import org.correomqtt.business.dispatcher.ShortcutObserver;
import org.correomqtt.business.dispatcher.SubscribeDispatcher;
import org.correomqtt.business.dispatcher.SubscribeObserver;
import org.correomqtt.business.dispatcher.UnsubscribeDispatcher;
import org.correomqtt.business.dispatcher.UnsubscribeObserver;
import org.correomqtt.business.exception.CorreoMqttException;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.model.Qos;
import org.correomqtt.business.model.SubscriptionDTO;
import org.correomqtt.business.services.PersistSubscriptionHistoryService;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.business.TaskFactory;
import org.correomqtt.gui.cell.QosCell;
import org.correomqtt.gui.cell.SubscriptionViewCell;
import org.correomqtt.gui.cell.TopicCell;
import org.correomqtt.gui.contextmenu.SubscriptionListMessageContextMenu;
import org.correomqtt.gui.contextmenu.SubscriptionListMessageContextMenuDelegate;
import org.correomqtt.gui.controller.BaseMessageBasedViewController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.SubscriptionViewDelegate;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.helper.CheckTopicHelper;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.correomqtt.gui.model.SubscriptionPropertiesDTO;
import org.correomqtt.gui.transformer.MessageTransformer;
import org.correomqtt.gui.transformer.SubscriptionTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionViewController
extends BaseMessageBasedViewController
implements SubscribeObserver,
UnsubscribeObserver,
ConnectionLifecycleObserver,
ShortcutObserver,
SubscriptionListMessageContextMenuDelegate,
PersistSubscriptionHistoryObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionViewController.class);
    private static ResourceBundle resources;
    private final SubscriptionViewDelegate delegate;
    @FXML
    public AnchorPane subscribeBodyViewAnchor;
    @FXML
    public ComboBox<Qos> qosComboBox;
    @FXML
    public ComboBox<String> subscribeTopicComboBox;
    @FXML
    public ListView<SubscriptionPropertiesDTO> subscriptionListView;
    @FXML
    private Button unsubscribeButton;
    @FXML
    private Button unsubscribeAllButton;
    @FXML
    private Button selectAllButton;
    @FXML
    private Button selectNoneButton;
    private boolean afterSubscribe;

    public SubscriptionViewController(String connectionId, SubscriptionViewDelegate delegate) {
        super(connectionId);
        this.delegate = delegate;
        SubscribeDispatcher.getInstance().addObserver(this);
        UnsubscribeDispatcher.getInstance().addObserver(this);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        ShortcutDispatcher.getInstance().addObserver(this);
        PersistSubscriptionHistoryDispatcher.getInstance().addObserver(this);
    }

    static LoaderResult<SubscriptionViewController> load(String connectionId, SubscriptionViewDelegate delegate) {
        LoaderResult<SubscriptionViewController> result = SubscriptionViewController.load(SubscriptionViewController.class, "subscriptionView.fxml", () -> new SubscriptionViewController(connectionId, delegate));
        resources = result.getResourceBundle();
        return result;
    }

    @FXML
    public void initialize() {
        this.initMessageListView();
        this.qosComboBox.setItems(FXCollections.observableArrayList((Object[])Qos.values()));
        this.qosComboBox.getSelectionModel().selectFirst();
        this.qosComboBox.setCellFactory(QosCell::new);
        this.subscriptionListView.setItems(FXCollections.observableArrayList(SubscriptionPropertiesDTO.extractor()));
        this.subscriptionListView.setCellFactory(this::createCell);
        this.unsubscribeButton.setDisable(true);
        this.unsubscribeAllButton.setDisable(true);
        this.selectAllButton.setDisable(true);
        this.selectNoneButton.setDisable(true);
        this.subscribeTopicComboBox.getEditor().lengthProperty().addListener((observable, oldValue, newValue) -> {
            CheckTopicHelper.checkSubscribeTopic(this.subscribeTopicComboBox, false, this.afterSubscribe);
            if (newValue.toString().length() > 0) {
                this.afterSubscribe = false;
            }
        });
        this.initTopicComboBox();
    }

    private void initTopicComboBox() {
        List<String> topics = PersistSubscriptionHistoryService.getInstance(this.getConnectionId()).getTopics(this.getConnectionId());
        this.subscribeTopicComboBox.setItems(FXCollections.observableArrayList(topics));
        this.subscribeTopicComboBox.setCellFactory(TopicCell::new);
    }

    private ListCell<SubscriptionPropertiesDTO> createCell(ListView<SubscriptionPropertiesDTO> listView) {
        SubscriptionViewCell cell = new SubscriptionViewCell(listView);
        SubscriptionListMessageContextMenu contextMenu = new SubscriptionListMessageContextMenu(this);
        cell.setContextMenu(contextMenu);
        cell.itemProperty().addListener((observable, oldValue, newValue) -> contextMenu.setObject((SubscriptionPropertiesDTO)cell.getItem()));
        cell.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.onSubscriptionSelected((SubscriptionPropertiesDTO)cell.getItem());
            }
        });
        return cell;
    }

    private void subscribe() {
        if (!CheckTopicHelper.checkSubscribeTopic(this.subscribeTopicComboBox, true, this.afterSubscribe)) {
            return;
        }
        String topic = (String)this.subscribeTopicComboBox.getValue();
        if (topic == null || topic.isEmpty()) {
            LOGGER.info("Topic must not be empty");
            this.subscribeTopicComboBox.getStyleClass().add((Object)"emptyError");
            return;
        }
        Qos selectedQos = (Qos)((Object)this.qosComboBox.getSelectionModel().getSelectedItem());
        TaskFactory.subscribe(this.getConnectionId(), SubscriptionPropertiesDTO.builder().topic(topic).qos(selectedQos).build());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Subscribing to topic '{}': {}", (Object)topic, (Object)this.getConnectionId());
        }
    }

    private SubscriptionPropertiesDTO getSelectedSubscription() {
        return (SubscriptionPropertiesDTO)this.subscriptionListView.getSelectionModel().getSelectedItem();
    }

    @FXML
    private void onClickUnsubscribe() {
        SubscriptionPropertiesDTO selectedSubscription = this.getSelectedSubscription();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unsubscribe from topic '{}' clicked: {}", (Object)selectedSubscription.getTopic(), (Object)this.getConnectionId());
        }
        if (selectedSubscription != null) {
            this.unsubscribe(selectedSubscription);
        }
    }

    @Override
    public void unsubscribe(SubscriptionPropertiesDTO subscriptionDTO) {
        TaskFactory.unsubscribe(this.getConnectionId(), subscriptionDTO);
    }

    @Override
    @FXML
    public void selectAll() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Select all topics for filter clicked: {}", (Object)this.getConnectionId());
        }
        this.subscriptionListView.getItems().forEach(subscriptionDTO -> subscriptionDTO.setFiltered(true));
    }

    @Override
    public void filterOnly(SubscriptionPropertiesDTO dto) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Filter only topic '{}': {}", (Object)dto.getTopic(), (Object)this.getConnectionId());
        }
        this.subscriptionListView.getItems().forEach(item -> item.setFiltered(dto.equals(item)));
    }

    @Override
    @FXML
    public void selectNone() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Select none topic for filter clicked: {}", (Object)this.getConnectionId());
        }
        this.subscriptionListView.getItems().forEach(subscriptionDTO -> subscriptionDTO.setFiltered(false));
    }

    @FXML
    private void onClickUnsubscribeAll() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unsubscribe from all topics clicked: {}", (Object)this.getConnectionId());
        }
        this.unsubscribeAll();
    }

    @Override
    public void unsubscribeAll() {
        ConnectionHolder.getInstance().getConnection(this.getConnectionId()).getClient().getSubscriptions().forEach(s -> TaskFactory.unsubscribe(this.getConnectionId(), SubscriptionTransformer.dtoToProps(s)));
        this.subscriptionListView.getItems().clear();
        this.unsubscribeButton.setDisable(true);
        this.unsubscribeAllButton.setDisable(true);
        this.selectAllButton.setDisable(true);
        this.selectNoneButton.setDisable(true);
    }

    public void onClickSubscribe(ActionEvent actionEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Subscribe to topic clicked: {}", (Object)this.getConnectionId());
        }
        this.subscribe();
    }

    public void onClickSubscribeKey(KeyEvent actionEvent) {
        if (actionEvent.getCode() == KeyCode.ENTER) {
            this.subscribeTopicComboBox.setValue((Object)this.subscribeTopicComboBox.getEditor().getText());
            if (this.subscribeTopicComboBox.getValue() == null) {
                return;
            }
            this.subscribe();
        }
    }

    @FXML
    public void onSubscriptionSelected(SubscriptionPropertiesDTO subscriptionDTO) {
        this.unsubscribeButton.setDisable(subscriptionDTO == null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Subscription selected '{}': {}", (Object)(subscriptionDTO == null ? "N/A" : subscriptionDTO.getTopic()), (Object)this.getConnectionId());
        }
    }

    @Override
    public void onMessageIncoming(MessageDTO messageDTO, SubscriptionDTO subscriptionDTO) {
        MessagePropertiesDTO messagePropertiesDTO = MessageTransformer.dtoToProps(messageDTO);
        messagePropertiesDTO.getSubscriptionDTOProperty().setValue((Object)SubscriptionTransformer.dtoToProps(subscriptionDTO));
        this.messageListViewController.onNewMessage(messagePropertiesDTO);
    }

    @Override
    public void onSubscribedSucceeded(SubscriptionDTO subscriptionDTO) {
        this.afterSubscribe = true;
        this.subscribeTopicComboBox.getSelectionModel().select((Object)"");
        if (subscriptionDTO.isHidden()) {
            return;
        }
        SubscriptionPropertiesDTO subscriptionPropertiesDTO = SubscriptionTransformer.dtoToProps(subscriptionDTO);
        this.subscriptionListView.getItems().add(0, (Object)subscriptionPropertiesDTO);
        this.unsubscribeAllButton.setDisable(false);
        this.selectAllButton.setDisable(false);
        this.selectNoneButton.setDisable(false);
        subscriptionPropertiesDTO.getFilteredProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != newValue) {
                this.updateFilter();
            }
        });
    }

    @Override
    public void onSubscribedCanceled(SubscriptionDTO subscriptionDTO) {
    }

    @Override
    public void onSubscribedFailed(SubscriptionDTO subscriptionDTO, Throwable exception) {
        Object msg = exception instanceof CorreoMqttException ? ((CorreoMqttException)exception).getInfo() : "Exception in business layer: " + exception.getMessage();
        AlertHelper.warn(resources.getString("subscribeViewControllerSubscriptionFailedTitle") + ": ", (String)msg);
    }

    private void updateFilter() {
        Set filteredTopics = this.subscriptionListView.getItems().stream().filter(dto -> dto.getFilteredProperty().getValue()).map(dto -> dto.getTopicProperty().getValue()).collect(Collectors.toSet());
        this.messageListViewController.setFilterPredicate(m -> {
            SubscriptionPropertiesDTO subscription = m.getSubscription();
            if (subscription == null) {
                return false;
            }
            return filteredTopics.contains(subscription.getTopic());
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Filter updated", (Object)this.getConnectionId());
        }
    }

    @Override
    public void setUpToForm(MessagePropertiesDTO messageDTO) {
        this.delegate.setUpToForm(messageDTO);
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onConnectRunning() {
    }

    @Override
    public void onConnectionFailed(Throwable message) {
    }

    @Override
    public void onConnectionCanceled() {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onDisconnect() {
        this.subscriptionListView.getItems().clear();
    }

    @Override
    public void onDisconnectCanceled() {
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onConnectionReconnected() {
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }

    @Override
    public void onSubscriptionShortcutPressed() {
    }

    @Override
    public void onClearIncomingShortcutPressed() {
    }

    @Override
    public void updateSubscriptions(String connectionId) {
        this.initTopicComboBox();
    }

    @Override
    public void errorReadingSubscriptionHistory(Throwable exception) {
    }

    @Override
    public void errorWritingSubscriptionHistory(Throwable exception) {
    }

    @Override
    public void onUnsubscribeSucceeded(SubscriptionDTO subscriptionDTO) {
        SubscriptionPropertiesDTO subscriptionToRemove = this.subscriptionListView.getItems().stream().filter(s -> s.getTopic().equals(subscriptionDTO.getTopic())).findFirst().orElse(null);
        if (subscriptionToRemove != null) {
            this.subscriptionListView.getItems().remove((Object)subscriptionToRemove);
            this.unsubscribeButton.setDisable(true);
            if (this.subscriptionListView.getItems().isEmpty()) {
                this.unsubscribeAllButton.setDisable(true);
                this.selectAllButton.setDisable(true);
                this.selectNoneButton.setDisable(true);
            }
        }
    }

    @Override
    public void onUnsubscribeCanceled(SubscriptionDTO subscriptionDTO) {
    }

    @Override
    public void onUnsubscribeFailed(SubscriptionDTO subscriptionDTO, Throwable exception) {
    }

    @Override
    public void removeMessage(MessageDTO messageDTO) {
    }

    @Override
    public void clearMessages() {
    }

    @Override
    public void setTabDirty() {
        this.delegate.setTabDirty();
    }
}

