/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.helper;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import org.correomqtt.business.services.SettingsService;
import org.correomqtt.gui.utils.PlatformUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertHelper.class);

    private AlertHelper() {
    }

    private static void showDialog(Alert.AlertType type, String title, String content, boolean block, ButtonType buttonType) {
        CountDownLatch countDownLatch = block ? new CountDownLatch(1) : null;
        PlatformUtils.runLaterIfNotInFxThread(() -> {
            Alert alert = new Alert(type);
            DialogPane dialogPane = alert.getDialogPane();
            String cssPath = SettingsService.getInstance().getCssPath();
            if (cssPath != null) {
                dialogPane.getStylesheets().add((Object)cssPath);
            }
            alert.setTitle(title);
            alert.setHeaderText(null);
            alert.setContentText(content);
            if (buttonType != null) {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonType});
            }
            alert.showAndWait();
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
        });
        if (countDownLatch != null) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Exception during showing dialog ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean showConfirmationDialog(String title, String header, String content, String noButton, String yesButton) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicBoolean result = new AtomicBoolean();
        PlatformUtils.runLaterIfNotInFxThread(() -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            DialogPane dialogPane = alert.getDialogPane();
            String cssPath = SettingsService.getInstance().getCssPath();
            if (cssPath != null) {
                dialogPane.getStylesheets().add((Object)cssPath);
            }
            alert.setTitle(title);
            alert.setHeaderText(header);
            alert.setContentText(content);
            ButtonType no = new ButtonType(noButton);
            ButtonType yes = new ButtonType(yesButton);
            if (noButton != null) {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{yes, no});
            } else {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{yes});
            }
            alert.showAndWait().ifPresentOrElse(buttonType -> result.set(buttonType.equals(yes)), () -> result.set(false));
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception during confirm dialog ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return result.get();
    }

    public static void info(String title, String content) {
        AlertHelper.info(title, content, false);
    }

    public static void info(String title, String content, boolean block) {
        AlertHelper.showDialog(Alert.AlertType.INFORMATION, title, content, block, null);
    }

    public static void info(String title, String content, boolean block, ButtonType buttonType) {
        AlertHelper.showDialog(Alert.AlertType.INFORMATION, title, content, block, buttonType);
    }

    public static void warn(String title, String content) {
        AlertHelper.warn(title, content, false);
    }

    public static void warn(String title, String content, boolean block) {
        AlertHelper.showDialog(Alert.AlertType.WARNING, title, content, block, null);
    }

    public static void warn(String title, String content, boolean block, ButtonType buttonType) {
        AlertHelper.showDialog(Alert.AlertType.WARNING, title, content, block, buttonType);
    }

    public static boolean confirm(String title, String header, String content, String noButton, String yesButton) {
        return AlertHelper.showConfirmationDialog(title, header, content, noButton, yesButton);
    }
}

