/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.plugin.model;

import com.sun.javafx.collections.ObservableMapWrapper;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableMap;
import org.correomqtt.business.model.Lwt;
import org.correomqtt.business.model.Qos;
import org.correomqtt.gui.model.ConnectionPropertiesDTO;

public class LwtConnectionExtensionDTO {
    private String id;
    private String name;
    private Lwt lwt;
    private String lwtTopic;
    private Qos lwtQoS;
    private boolean lwtRetained;
    private String lwtPayload;
    private HashMap<String, Object> customFields;

    public LwtConnectionExtensionDTO(ConnectionPropertiesDTO connectionPropertiesDTO) {
        this.id = connectionPropertiesDTO.getId();
        this.name = connectionPropertiesDTO.getName();
        this.lwt = connectionPropertiesDTO.getLwt();
        this.lwtTopic = connectionPropertiesDTO.getLwtTopic();
        this.lwtQoS = connectionPropertiesDTO.getLwtQos();
        this.lwtRetained = connectionPropertiesDTO.isLwtRetained();
        this.lwtPayload = connectionPropertiesDTO.getLwtPayload();
        this.customFields = new HashMap<String, Object>((Map<String, Object>)connectionPropertiesDTO.getExtraProperties());
    }

    public ConnectionPropertiesDTO merge(ConnectionPropertiesDTO activeConnectionConfigDTO) {
        activeConnectionConfigDTO.getIdProperty().setValue(this.id);
        activeConnectionConfigDTO.getNameProperty().setValue(this.name);
        activeConnectionConfigDTO.getLwtProperty().setValue((Object)this.lwt);
        activeConnectionConfigDTO.getLwtTopicProperty().setValue(this.lwtTopic);
        activeConnectionConfigDTO.getLwtQoSProperty().setValue((Object)this.lwtQoS);
        activeConnectionConfigDTO.getLwtRetainedProperty().setValue(Boolean.valueOf(this.lwtRetained));
        activeConnectionConfigDTO.getLwtPayloadProperty().setValue(this.lwtPayload);
        activeConnectionConfigDTO.getExtraProperties().setValue((ObservableMap)new ObservableMapWrapper(this.customFields));
        return activeConnectionConfigDTO;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLwt(Lwt lwt) {
        this.lwt = lwt;
    }

    public void setLwtTopic(String lwtTopic) {
        this.lwtTopic = lwtTopic;
    }

    public void setLwtQoS(Qos lwtQoS) {
        this.lwtQoS = lwtQoS;
    }

    public void setLwtRetained(boolean lwtRetained) {
        this.lwtRetained = lwtRetained;
    }

    public void setLwtPayload(String lwtPayload) {
        this.lwtPayload = lwtPayload;
    }

    public void setCustomFields(HashMap<String, Object> customFields) {
        this.customFields = customFields;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Lwt getLwt() {
        return this.lwt;
    }

    public String getLwtTopic() {
        return this.lwtTopic;
    }

    public Qos getLwtQoS() {
        return this.lwtQoS;
    }

    public boolean isLwtRetained() {
        return this.lwtRetained;
    }

    public String getLwtPayload() {
        return this.lwtPayload;
    }

    public HashMap<String, Object> getCustomFields() {
        return this.customFields;
    }
}

