/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.plugin.update;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.correomqtt.business.dispatcher.PreloadingDispatcher;
import org.correomqtt.business.services.SettingsService;
import org.correomqtt.business.utils.VendorConstants;
import org.correomqtt.business.utils.VersionUtils;
import org.correomqtt.plugin.exception.CorreoMqttPluginUpdateException;
import org.correomqtt.plugin.manager.PluginSystem;
import org.pf4j.PluginManager;
import org.pf4j.update.DefaultUpdateRepository;
import org.pf4j.update.PluginInfo;
import org.pf4j.update.UpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpdateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginUpdateManager.class);
    private final PluginSystem pluginSystem;
    private ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsService.getInstance().getSettings().getCurrentLocale());

    public PluginUpdateManager(PluginSystem pluginSystem) {
        this.pluginSystem = pluginSystem;
    }

    public void updateSystem() throws Exception {
        LOGGER.info("Start Plugin Update");
        URL versionRepo = new URL(VendorConstants.PLUGIN_REPO_URL);
        HttpURLConnection connection = (HttpURLConnection)versionRepo.openConnection();
        if (connection.getResponseCode() == 200) {
            List<DefaultUpdateRepository> repos = Collections.singletonList(new DefaultUpdateRepository("bundled", versionRepo, "plugins-" + VersionUtils.getVersion() + ".json"));
            UpdateManager updateManager = new UpdateManager((PluginManager)this.pluginSystem, repos);
            this.updateExisitingPlugins(updateManager);
            this.installNewPlugins(updateManager);
        } else {
            LOGGER.info("No default plugins available.");
        }
    }

    private void installNewPlugins(UpdateManager updateManager) {
        if (updateManager.hasAvailablePlugins()) {
            List availablePlugins = updateManager.getAvailablePlugins();
            LOGGER.info("Found {} available plugins", (Object)availablePlugins.size());
            for (PluginInfo plugin : availablePlugins) {
                LOGGER.info("Found available plugin '{}'", (Object)plugin.id);
                PluginInfo.PluginRelease lastRelease = updateManager.getLastPluginRelease(plugin.id);
                String lastVersion = lastRelease.version;
                LOGGER.info("Install plugin '{}' with version {}", (Object)plugin.id, (Object)lastVersion);
                boolean installed = updateManager.installPlugin(plugin.id, lastVersion);
                if (installed) {
                    LOGGER.info("Installed plugin '{}'", (Object)plugin.id);
                    PreloadingDispatcher.getInstance().onProgress(this.resources.getString("pluginUpdateManagerInstalled") + " " + plugin.id);
                    continue;
                }
                LOGGER.error("Cannot install plugin '{}'", (Object)plugin.id);
            }
        } else {
            LOGGER.info("No available plugins found");
        }
    }

    private void updateExisitingPlugins(UpdateManager updateManager) throws Exception {
        if (updateManager.hasUpdates()) {
            List updates = updateManager.getUpdates();
            LOGGER.info("Found {} plugin updates", (Object)updates.size());
            for (PluginInfo plugin : updates) {
                boolean updated;
                LOGGER.info("Found update for plugin '{}'", (Object)plugin.id);
                PluginInfo.PluginRelease lastRelease = updateManager.getLastPluginRelease(plugin.id);
                String lastVersion = lastRelease.version;
                String installedVersion = this.pluginSystem.getPlugin(plugin.id).getDescriptor().getVersion();
                LOGGER.info("Update plugin '{}' from version {} to version {}", new Object[]{plugin.id, installedVersion, lastVersion});
                try {
                    updated = updateManager.updatePlugin(plugin.id, lastVersion);
                }
                catch (Throwable t) {
                    updated = false;
                }
                if (updated) {
                    LOGGER.info("Updated plugin '{}'", (Object)plugin.id);
                    PreloadingDispatcher.getInstance().onProgress(this.resources.getString("pluginUpdateManagerUpdated") + " " + plugin.id);
                    continue;
                }
                LOGGER.error("Cannot update plugin '{}'", (Object)plugin.id);
                throw new CorreoMqttPluginUpdateException(plugin.id);
            }
        } else {
            LOGGER.info("No updates found");
        }
    }
}

