/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.correomqtt.business.dispatcher.ApplicationLifecycleDispatcher;
import org.correomqtt.business.dispatcher.PreloadingDispatcher;
import org.correomqtt.business.dispatcher.ShortcutDispatcher;
import org.correomqtt.business.dispatcher.StartupDispatcher;
import org.correomqtt.business.dispatcher.StartupObserver;
import org.correomqtt.business.model.SettingsDTO;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.business.utils.VersionUtils;
import org.correomqtt.gui.controller.AlertController;
import org.correomqtt.gui.controller.MainViewController;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.keyring.KeyringHandler;
import org.correomqtt.gui.utils.CheckNewVersionUtils;
import org.correomqtt.gui.utils.HostServicesHolder;
import org.correomqtt.plugin.PluginSystem;
import org.correomqtt.plugin.manager.PluginManager;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorreoMqtt
extends Application
implements StartupObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorreoMqtt.class);
    private ResourceBundle resources;
    private MainViewController mainViewController;
    private Scene scene;

    public static void main(String[] args) {
        CorreoMqtt.launch((String[])args);
    }

    public void init() throws IOException {
        LOGGER.info("Application started.");
        LOGGER.info("JVM: {} | {} | {}.", new Object[]{System.getProperty("java.vendor"), System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")});
        LOGGER.info("CorreoMQTT version is {}.", (Object)VersionUtils.getVersion());
        StartupDispatcher.getInstance().addObserver(this);
        SettingsDTO settings = SettingsProvider.getInstance().getSettings();
        this.handleVersionMismatch(settings);
        this.setLocale(settings);
        HostServicesHolder.getInstance().setHostServices(this.getHostServices());
        PreloadingDispatcher.getInstance().onProgress(this.resources.getString("preloaderLanguageSet"));
        if (settings.isFirstStart()) {
            this.initUpdatesOnFirstStart(settings);
        }
        if (settings.isSearchUpdates()) {
            PreloadingDispatcher.getInstance().onProgress(this.resources.getString("preloaderSearchingUpdates"));
            new PluginSystem().start();
            this.checkForUpdates();
        }
        PreloadingDispatcher.getInstance().onProgress(this.resources.getString("preloaderKeyring"));
        KeyringHandler.getInstance().init();
        KeyringHandler.getInstance().retryWithMasterPassword(masterPassword -> SettingsProvider.getInstance().initializePasswords(masterPassword), this.resources.getString("onPasswordReadFailedTitle"), this.resources.getString("onPasswordReadFailedHeader"), this.resources.getString("onPasswordReadFailedContent"), this.resources.getString("onPasswordReadFailedGiveUp"), this.resources.getString("onPasswordReadFailedTryAgain"));
        PreloadingDispatcher.getInstance().onProgress(this.resources.getString("preloaderReady"));
        SettingsProvider.getInstance().saveSettings();
    }

    private void handleVersionMismatch(SettingsDTO settings) {
        if (settings.getConfigCreatedWithCorreoVersion() == null) {
            LOGGER.info("Setting initial correo version in settings: {}", (Object)VersionUtils.getVersion());
            settings.setConfigCreatedWithCorreoVersion(VersionUtils.getVersion());
        } else if (new ComparableVersion(VersionUtils.getVersion()).compareTo(new ComparableVersion(settings.getConfigCreatedWithCorreoVersion())) > 0) {
            LOGGER.info("Installed version is newer than version which created the config file");
        }
    }

    private void initUpdatesOnFirstStart(SettingsDTO settings) {
        boolean checkForUpdates = AlertHelper.confirm(this.resources.getString("settingsViewUpdateLabel"), null, this.resources.getString("firstStartCheckForUpdatesTitle"), this.resources.getString("commonNoButton"), this.resources.getString("commonYesButton"));
        settings.setFirstStart(false);
        settings.setSearchUpdates(checkForUpdates);
    }

    private void setLocale(SettingsDTO settings) {
        if (settings.getSavedLocale() == null) {
            if (Locale.getDefault().getLanguage().equals("de") && Locale.getDefault().getCountry().equals("DE")) {
                settings.setSavedLocale(new Locale("de", "DE"));
            } else {
                settings.setSavedLocale(new Locale("en", "US"));
            }
        }
        settings.setCurrentLocale(settings.getSavedLocale());
        LOGGER.info("Locale is: {}", (Object)settings.getSavedLocale());
        this.resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
    }

    private void checkForUpdates() {
        try {
            CheckNewVersionUtils.checkNewVersion(false);
        }
        catch (IOException | ParseException e) {
            LOGGER.warn("Version check failed.", e);
        }
    }

    public void start(Stage primaryStage) throws Exception {
        this.loadPrimaryStage(primaryStage);
        AlertController.activate();
    }

    private void loadPrimaryStage(Stage primaryStage) throws IOException {
        String cssPath = SettingsProvider.getInstance().getCssPath();
        FXMLLoader loader = new FXMLLoader(MainViewController.class.getResource("mainView.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale()));
        Parent root = (Parent)loader.load();
        this.mainViewController = (MainViewController)loader.getController();
        primaryStage.setTitle("CorreoMQTT v" + VersionUtils.getVersion());
        this.scene = new Scene(root, 900.0, 800.0);
        if (cssPath != null) {
            this.scene.getStylesheets().add((Object)cssPath);
        }
        primaryStage.setScene(this.scene);
        primaryStage.setMinHeight(400.0);
        primaryStage.setMinWidth(850.0);
        primaryStage.show();
        primaryStage.setOnCloseRequest(t -> {
            LOGGER.info("Main window closed. Initialize shutdown.");
            LOGGER.info("Shutting down connections.");
            ApplicationLifecycleDispatcher.getInstance().onShutdown();
            LOGGER.info("Shutting down plugins.");
            PluginManager.getInstance().stopPlugins();
            LOGGER.info("Shutting down application. Bye.");
            Platform.exit();
            System.exit(0);
        });
        this.setupShortcut();
    }

    private void setupShortcut() {
        this.scene.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode().equals((Object)KeyCode.S) && event.isShortcutDown() && !event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onSubscriptionShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
            if (event.getCode().equals((Object)KeyCode.S) && event.isShortcutDown() && event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onClearIncomingShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
            if (event.getCode().equals((Object)KeyCode.P) && event.isShortcutDown() && !event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onPublishShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
            if (event.getCode().equals((Object)KeyCode.P) && event.isShortcutDown() && event.isShiftDown()) {
                ShortcutDispatcher.getInstance().onClearOutgoingShortcutPressed(this.mainViewController.getUUIDofSelectedTab());
                event.consume();
            }
        });
    }

    private void setLoggerFilePath() {
        System.setProperty("correomqtt-logfile", SettingsProvider.getInstance().getLogPath());
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ContextInitializer ci = new ContextInitializer(lc);
        lc.reset();
        try {
            ci.autoConfig();
        }
        catch (JoranException e) {
            e.printStackTrace();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
    }

    @Override
    public void onPluginUpdateFailed(String disabledPath) {
        AlertHelper.warn(this.resources.getString("pluginUpdateErrorTitle"), this.resources.getString("pluginUpdateErrorContent") + " " + disabledPath, true);
    }

    @Override
    public void onPluginLoadFailed() {
        AlertHelper.warn(this.resources.getString("pluginErrorTitle"), this.resources.getString("pluginErrorContent"), true, new ButtonType(this.resources.getString("closeNow"), ButtonBar.ButtonData.OK_DONE));
        System.exit(1);
    }
}

