/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.sun.glass.ui.Application;
import java.io.IOException;
import java.io.InputStream;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.transform.Rotate;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.correomqtt.business.dispatcher.PreloadingDispatcher;
import org.correomqtt.business.dispatcher.PreloadingObserver;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.business.utils.VersionUtils;
import org.correomqtt.gui.controller.PreloaderViewController;
import org.slf4j.LoggerFactory;

public class CorreoPreloader
extends Preloader
implements PreloadingObserver {
    PreloaderViewController preloaderViewController;
    private Scene scene;
    private Stage preloaderStage;

    public CorreoPreloader() {
        PreloadingDispatcher.getInstance().addObserver(this);
    }

    public void init() throws IOException {
        this.setLoggerFilePath();
        String cssPath = SettingsProvider.getInstance().getCssPath();
        FXMLLoader loader = new FXMLLoader(PreloaderViewController.class.getResource("preloaderView.fxml"));
        Parent root = (Parent)loader.load();
        this.preloaderViewController = (PreloaderViewController)loader.getController();
        this.preloaderViewController.getPreloaderVersionLabel().setText("v" + VersionUtils.getVersion());
        this.scene = new Scene(root, 500.0, 300.0);
        if (cssPath != null) {
            this.scene.getStylesheets().add((Object)cssPath);
        }
    }

    private void setLoggerFilePath() {
        System.setProperty("correomqtt-logfile", SettingsProvider.getInstance().getLogPath());
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        try (InputStream configStream = CorreoPreloader.class.getResourceAsStream("logger-config.xml");){
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure(configStream);
        }
        catch (JoranException | IOException e) {
            e.printStackTrace();
        }
    }

    public void start(Stage primaryStage) throws Exception {
        Application.GetApplication().setName("org.correomqtt.CorreoMqtt");
        this.preloaderStage = primaryStage;
        this.preloaderStage.setScene(this.scene);
        this.preloaderStage.initStyle(StageStyle.UNDECORATED);
        RotateTransition rotateTransition = new RotateTransition();
        rotateTransition.setAxis(Rotate.Z_AXIS);
        rotateTransition.setByAngle(360.0);
        rotateTransition.setCycleCount(-1);
        rotateTransition.setDuration(Duration.millis((double)1000.0));
        rotateTransition.setNode((Node)this.preloaderViewController.getPreloaderProgressLabel());
        rotateTransition.setInterpolator(Interpolator.LINEAR);
        rotateTransition.play();
        this.preloaderStage.show();
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification stateChangeNotification) {
        if (stateChangeNotification.getType() == Preloader.StateChangeNotification.Type.BEFORE_START) {
            this.preloaderStage.hide();
        }
    }

    @Override
    public void onProgress(Double progress, String message) {
        Platform.runLater(() -> this.preloaderViewController.getPreloaderStepLabel().setText(message));
    }
}

