/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.dispatcher;

import java.io.File;
import org.correomqtt.business.dispatcher.BaseConnectionDispatcher;
import org.correomqtt.business.dispatcher.ImportMessageObserver;
import org.correomqtt.business.model.MessageDTO;

public class ImportMessageDispatcher
extends BaseConnectionDispatcher<ImportMessageObserver> {
    private static ImportMessageDispatcher instance;

    public static synchronized ImportMessageDispatcher getInstance() {
        if (instance == null) {
            instance = new ImportMessageDispatcher();
        }
        return instance;
    }

    public void onImportStarted(String connectionId, File file) {
        this.triggerFiltered(connectionId, o -> o.onImportStarted(file));
    }

    public void onImportSucceeded(String connectionId, MessageDTO messageDTO) {
        this.triggerFiltered(connectionId, o -> o.onImportSucceeded(messageDTO));
    }

    public void onImportCancelled(String connectionId, File file) {
        this.triggerFiltered(connectionId, o -> o.onImportCancelled(file));
    }

    public void onImportFailed(String connectionId, File file, Throwable exception) {
        this.triggerFiltered(connectionId, o -> o.onImportFailed(file, exception));
    }

    public void onImportRunning(String connectionId) {
        this.triggerFiltered(connectionId, ImportMessageObserver::onImportRunning);
    }

    public void onImportScheduled(String connectionId) {
        this.triggerFiltered(connectionId, ImportMessageObserver::onImportScheduled);
    }
}

