/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.keyring.kwallet5;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.ResourceBundle;
import org.correomqtt.business.keyring.BaseKeyring;
import org.correomqtt.business.keyring.KeyringException;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.plugin.spi.KeyringHook;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class KWallet5Keyring
extends BaseKeyring
implements KeyringHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(KWallet5Keyring.class);
    private static final String APP_NAME = "CorreoMQTT";
    private static final String WALLET_NAME = "kdewallet";
    private static final String QDBUS_BASE_CMD = "qdbus org.kde.kwalletd5 /modules/kwalletd5";
    private static final Charset STD_CHAR_SET = StandardCharsets.UTF_8;
    private ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
    private Integer kwalletHandler = null;

    @Override
    public String getPassword(String label) {
        return new String(Base64.getDecoder().decode(this.readPassword(this.getKWalletHandler(), label).getBytes(STD_CHAR_SET)));
    }

    @Override
    public void setPassword(String label, String password) {
        if (password == null || password.isEmpty()) {
            this.removeEntry(this.getKWalletHandler(), label);
        } else {
            this.writePassword(this.getKWalletHandler(), label, Base64.getEncoder().encodeToString(password.getBytes(STD_CHAR_SET)));
        }
    }

    @Override
    public boolean isSupported() {
        return Platform.isLinux() && this.isEnabled();
    }

    @Override
    public String getIdentifier() {
        return "KWallet5";
    }

    @Override
    public String getName() {
        return this.resources.getString("kwallet5Name");
    }

    @Override
    public String getDescription() {
        return this.resources.getString("kwallet5Description");
    }

    private synchronized int getKWalletHandler() {
        if (this.kwalletHandler == null || !this.isOpen(this.kwalletHandler)) {
            this.kwalletHandler = this.openWallet();
        }
        return this.kwalletHandler;
    }

    private boolean isOpen(Integer kwalletHandler) {
        try {
            return this.runQDBusCommand("isOpen", String.valueOf(kwalletHandler)).equals("true");
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Cannot check KWallet", (Throwable)e);
            throw new KeyringException("Cannot check KWallet", e);
        }
    }

    private int openWallet() {
        try {
            String result = this.runQDBusCommand("open", WALLET_NAME, "0", APP_NAME);
            return Integer.parseInt(result);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Cannot open KWallet", (Throwable)e);
            throw new KeyringException("Cannot open KWallet", e);
        }
    }

    private void writePassword(int handler, String key, String password) {
        try {
            String result = this.runQDBusCommand("writePassword", String.valueOf(handler), APP_NAME, key, password, APP_NAME);
            if (Integer.parseInt(result) < 0) {
                LOGGER.error("Cannot store password in KWallet.");
                throw new KeyringException("Cannot store password in KWallet.");
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Cannot store password in KWallet", (Throwable)e);
            throw new KeyringException("Cannot store password in KWallet", e);
        }
    }

    private void removeEntry(int handler, String key) {
        try {
            this.runQDBusCommand("removeEntry", String.valueOf(handler), APP_NAME, key, APP_NAME);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Cannot remove password from KWallet", (Throwable)e);
            throw new KeyringException("Cannot remove password from KWallet", e);
        }
    }

    private String readPassword(int handler, String key) {
        try {
            return this.runQDBusCommand("readPassword", String.valueOf(handler), APP_NAME, key, APP_NAME);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Cannot get password from KWallet", (Throwable)e);
            throw new KeyringException("Cannot get password from KWallet", e);
        }
    }

    private boolean isEnabled() {
        try {
            return this.runQDBusCommand("isEnabled").equals("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    private String runQDBusCommand(String ... parameter) throws IOException, InterruptedException {
        return this.runShellCommand("qdbus org.kde.kwalletd5 /modules/kwalletd5 " + String.join((CharSequence)" ", parameter));
    }

    private String runShellCommand(String cmd) throws IOException, InterruptedException {
        String s;
        StringBuilder result = new StringBuilder();
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((s = br.readLine()) != null) {
            result.append(s);
        }
        p.waitFor();
        if (p.exitValue() != 0) {
            LOGGER.error("Command failed with exit code {}", (Object)p.exitValue());
            throw new KeyringException("Command failed with exit code " + p.exitValue());
        }
        p.destroy();
        return result.toString();
    }
}

