/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.keyring.libsecret;

import com.sun.jna.Platform;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.correomqtt.business.keyring.BaseKeyring;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.plugin.spi.KeyringHook;
import org.freedesktop.secret.simple.SimpleCollection;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class LibSecretKeyring
extends BaseKeyring
implements KeyringHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibSecretKeyring.class);
    private ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());

    @Override
    public String getPassword(String label) {
        String item = this.findItem(label);
        if (item == null) {
            return null;
        }
        return this.getSecret(item);
    }

    @Override
    public void setPassword(String label, String password) {
        String item = this.findItem(label);
        if (item == null) {
            this.createItem(label, password);
        } else {
            this.updateItem(item, label, password);
        }
    }

    @Override
    public boolean isSupported() {
        return Platform.isLinux() && this.isAvailable();
    }

    @Override
    public String getIdentifier() {
        return "LibSecret";
    }

    @Override
    public String getName() {
        return this.resources.getString("libSecretName");
    }

    @Override
    public String getDescription() {
        return this.resources.getString("libSecretDescription");
    }

    private boolean isAvailable() {
        boolean bl;
        SimpleCollection collection = new SimpleCollection();
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    collection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.debug("Try to detect libsecret failed. This is not a real problem.", (Throwable)e);
                return false;
            }
        }
        collection.close();
        return bl;
    }

    private void updateItem(String item, String label, String password) {
        try (SimpleCollection collection = new SimpleCollection();){
            collection.updateItem(item, label, (CharSequence)password, Collections.emptyMap());
        }
        catch (IOException e) {
            LOGGER.error("Could not update item {} with label {} in libsecret", new Object[]{item, label, e});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findItem(String label) {
        try (SimpleCollection collection = new SimpleCollection();){
            String i;
            HashMap<String, String> searchMap = new HashMap<String, String>();
            searchMap.put("xdg:schema", "org.freedesktop.Secret.Generic");
            List items = collection.getItems(searchMap);
            if (items == null) return null;
            Iterator iterator = items.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (!label.equals(collection.getLabel(i = (String)iterator.next())));
            String string = i;
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Could not search for item with label {} from libsecret", (Object)label, (Object)e);
        }
        return null;
    }

    private void createItem(String label, String password) {
        try (SimpleCollection collection = new SimpleCollection();){
            collection.createItem(label, (CharSequence)password);
        }
        catch (IOException e) {
            LOGGER.error("Could not create item with libsecret for label {}", (Object)label, (Object)e);
        }
    }

    private String getSecret(String item) {
        String string;
        SimpleCollection collection = new SimpleCollection();
        try {
            string = String.valueOf(collection.getSecret(item));
        }
        catch (Throwable throwable) {
            try {
                try {
                    collection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Could not get secret from libsecret path {}", (Object)item, (Object)e);
                return null;
            }
        }
        collection.close();
        return string;
    }
}

