/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.keyring.windpapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.windpapi4j.InitializationFailedException;
import com.github.windpapi4j.WinAPICallFailedException;
import com.github.windpapi4j.WinDPAPI;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.correomqtt.business.keyring.BaseKeyring;
import org.correomqtt.business.keyring.KeyringException;
import org.correomqtt.business.keyring.windpapi.WinDPAPIKeyringDTO;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.plugin.spi.KeyringHook;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class WinDPAPIKeyring
extends BaseKeyring
implements KeyringHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(WinDPAPIKeyring.class);
    private static final Charset STD_CHAR_SET = StandardCharsets.UTF_8;
    private ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());

    @Override
    public boolean requiresUserinput() {
        return false;
    }

    @Override
    public String getName() {
        return this.resources.getString("windpapiName");
    }

    @Override
    public String getDescription() {
        return this.resources.getString("windpapiDescription");
    }

    @Override
    public String getPassword(String label) {
        Map<String, String> data = this.readData();
        return data.get(label);
    }

    @Override
    public void setPassword(String label, String password) {
        Map<String, String> data = this.readData();
        data.put(label, password);
        this.writeData(data);
    }

    private void writeData(Map<String, String> data) {
        try {
            File file = this.getFile();
            LOGGER.debug("Write encoded string {}", (Object)Base64.getEncoder().encodeToString(this.protect(data)));
            new ObjectMapper().writeValue(file, (Object)WinDPAPIKeyringDTO.builder().data(Base64.getEncoder().encodeToString(this.protect(data))).build());
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to write json data for WinDPAPI.", (Throwable)e);
            throw new KeyringException("Failed to write json data for WinDPAPI.", (Exception)((Object)e));
        }
        catch (IOException e) {
            LOGGER.error("Failed to write file with data from WinDPAPI.", (Throwable)e);
            throw new KeyringException("Failed to write file with data from WinDPAPI.", e);
        }
    }

    private byte[] protect(Map<String, String> data) {
        try {
            String unprotectedData = new ObjectMapper().writeValueAsString(data);
            WinDPAPI winDPAPI = WinDPAPI.newInstance((WinDPAPI.CryptProtectFlag[])new WinDPAPI.CryptProtectFlag[]{WinDPAPI.CryptProtectFlag.CRYPTPROTECT_UI_FORBIDDEN});
            return winDPAPI.protectData(unprotectedData.getBytes(STD_CHAR_SET));
        }
        catch (InitializationFailedException | WinAPICallFailedException e) {
            LOGGER.error("Failed to unprotect data with WinDPAPI.", e);
            throw new KeyringException("Failed to unprotect data with WinDPAPI.", (Exception)e);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to parse data from WinDPAPI.", (Throwable)e);
            throw new KeyringException("Failed to parse data from WinDPAPI.", (Exception)((Object)e));
        }
    }

    private Map<String, String> readData() {
        File file = this.getFile();
        if (file.exists()) {
            try {
                WinDPAPIKeyringDTO winDPAPIKeyringDTO = (WinDPAPIKeyringDTO)new ObjectMapper().readValue(file, WinDPAPIKeyringDTO.class);
                byte[] data = Base64.getDecoder().decode(winDPAPIKeyringDTO.getData().getBytes(STD_CHAR_SET));
                return this.unprotect(data);
            }
            catch (IOException e) {
                LOGGER.error("Reading WinDPAPI file failed.", (Throwable)e);
                throw new KeyringException("Reading WinDPAPI file failed.", e);
            }
        }
        return new HashMap<String, String>();
    }

    private Map<String, String> unprotect(byte[] protectedData) {
        try {
            WinDPAPI winDPAPI = WinDPAPI.newInstance((WinDPAPI.CryptProtectFlag[])new WinDPAPI.CryptProtectFlag[]{WinDPAPI.CryptProtectFlag.CRYPTPROTECT_UI_FORBIDDEN});
            String unprotectedData = new String(winDPAPI.unprotectData(protectedData), STD_CHAR_SET);
            return (Map)new ObjectMapper().readValue(unprotectedData, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (InitializationFailedException | WinAPICallFailedException e) {
            LOGGER.error("Failed to unprotect data with WinDPAPI.", e);
            throw new KeyringException("Failed to unprotect data with WinDPAPI.", (Exception)e);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to parse data from WinDPAPI.", (Throwable)e);
            throw new KeyringException("Failed to parse data from WinDPAPI.", (Exception)((Object)e));
        }
    }

    private File getFile() {
        String windpapiPath = SettingsProvider.getInstance().getTargetDirectoryPath() + File.separator + "windpapi.json";
        return new File(windpapiPath);
    }

    @Override
    public boolean isSupported() {
        return WinDPAPI.isPlatformSupported();
    }

    @Override
    public String getIdentifier() {
        return "WinDPAPI";
    }
}

