/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.correomqtt.business.model.Auth;
import org.correomqtt.business.model.CorreoMqttVersion;
import org.correomqtt.business.model.Lwt;
import org.correomqtt.business.model.Proxy;
import org.correomqtt.business.model.Qos;
import org.correomqtt.business.model.TlsSsl;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectionConfigDTO {
    private String id;
    private String name;
    private String url;
    private int port;
    private String clientId;
    private String username;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    private boolean cleanSession;
    private CorreoMqttVersion mqttVersion;
    private TlsSsl ssl;
    private String sslKeystore;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String sslKeystorePassword;
    private Proxy proxy;
    private String sshHost;
    private int sshPort;
    private int localPort;
    private Auth auth;
    private String authUsername;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String authPassword;
    private String authKeyfile;
    private Lwt lwt;
    private String lwtTopic;
    private Qos lwtQoS;
    private boolean lwtRetained;
    private String lwtPayload;

    public ConnectionConfigDTO(ConnectionConfigDTO configDTO) {
        this.id = configDTO.id;
        this.name = configDTO.name;
        this.url = configDTO.url;
        this.port = configDTO.port;
        this.clientId = configDTO.clientId;
        this.username = configDTO.username;
        this.password = configDTO.password;
        this.cleanSession = configDTO.cleanSession;
        this.mqttVersion = configDTO.mqttVersion;
        this.ssl = configDTO.ssl;
        this.sslKeystore = configDTO.sslKeystore;
        this.sslKeystorePassword = configDTO.sslKeystorePassword;
        this.proxy = configDTO.proxy;
        this.sshHost = configDTO.sshHost;
        this.sshPort = configDTO.sshPort;
        this.localPort = configDTO.localPort;
        this.auth = configDTO.auth;
        this.authPassword = configDTO.authPassword;
        this.authKeyfile = configDTO.authKeyfile;
    }

    public String getHostAndPort() {
        if (this.getProxy().equals(Proxy.SSH)) {
            return "via " + this.getSshHost() + ":" + this.getSshPort();
        }
        return this.getUrl() + ":" + this.getPort();
    }

    private static int $default$port() {
        return 1883;
    }

    private static CorreoMqttVersion $default$mqttVersion() {
        return CorreoMqttVersion.MQTT_3_1_1;
    }

    private static TlsSsl $default$ssl() {
        return TlsSsl.OFF;
    }

    private static Proxy $default$proxy() {
        return Proxy.OFF;
    }

    private static int $default$sshPort() {
        return 22;
    }

    private static Auth $default$auth() {
        return Auth.OFF;
    }

    private static Lwt $default$lwt() {
        return Lwt.OFF;
    }

    public static ConnectionConfigDTOBuilder builder() {
        return new ConnectionConfigDTOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public int getPort() {
        return this.port;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public CorreoMqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    public TlsSsl getSsl() {
        return this.ssl;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getSshHost() {
        return this.sshHost;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public String getAuthKeyfile() {
        return this.authKeyfile;
    }

    public Lwt getLwt() {
        return this.lwt;
    }

    public String getLwtTopic() {
        return this.lwtTopic;
    }

    public Qos getLwtQoS() {
        return this.lwtQoS;
    }

    public boolean isLwtRetained() {
        return this.lwtRetained;
    }

    public String getLwtPayload() {
        return this.lwtPayload;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setPassword(String password) {
        this.password = password;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public void setMqttVersion(CorreoMqttVersion mqttVersion) {
        this.mqttVersion = mqttVersion;
    }

    public void setSsl(TlsSsl ssl) {
        this.ssl = ssl;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setSshHost(String sshHost) {
        this.sshHost = sshHost;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public void setAuthUsername(String authUsername) {
        this.authUsername = authUsername;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public void setAuthKeyfile(String authKeyfile) {
        this.authKeyfile = authKeyfile;
    }

    public void setLwt(Lwt lwt) {
        this.lwt = lwt;
    }

    public void setLwtTopic(String lwtTopic) {
        this.lwtTopic = lwtTopic;
    }

    public void setLwtQoS(Qos lwtQoS) {
        this.lwtQoS = lwtQoS;
    }

    public void setLwtRetained(boolean lwtRetained) {
        this.lwtRetained = lwtRetained;
    }

    public void setLwtPayload(String lwtPayload) {
        this.lwtPayload = lwtPayload;
    }

    public ConnectionConfigDTO() {
        this.port = ConnectionConfigDTO.$default$port();
        this.mqttVersion = ConnectionConfigDTO.$default$mqttVersion();
        this.ssl = ConnectionConfigDTO.$default$ssl();
        this.proxy = ConnectionConfigDTO.$default$proxy();
        this.sshPort = ConnectionConfigDTO.$default$sshPort();
        this.auth = ConnectionConfigDTO.$default$auth();
        this.lwt = ConnectionConfigDTO.$default$lwt();
    }

    public ConnectionConfigDTO(String id, String name, String url, int port, String clientId, String username, String password, boolean cleanSession, CorreoMqttVersion mqttVersion, TlsSsl ssl, String sslKeystore, String sslKeystorePassword, Proxy proxy, String sshHost, int sshPort, int localPort, Auth auth, String authUsername, String authPassword, String authKeyfile, Lwt lwt, String lwtTopic, Qos lwtQoS, boolean lwtRetained, String lwtPayload) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.port = port;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.cleanSession = cleanSession;
        this.mqttVersion = mqttVersion;
        this.ssl = ssl;
        this.sslKeystore = sslKeystore;
        this.sslKeystorePassword = sslKeystorePassword;
        this.proxy = proxy;
        this.sshHost = sshHost;
        this.sshPort = sshPort;
        this.localPort = localPort;
        this.auth = auth;
        this.authUsername = authUsername;
        this.authPassword = authPassword;
        this.authKeyfile = authKeyfile;
        this.lwt = lwt;
        this.lwtTopic = lwtTopic;
        this.lwtQoS = lwtQoS;
        this.lwtRetained = lwtRetained;
        this.lwtPayload = lwtPayload;
    }

    public static class ConnectionConfigDTOBuilder {
        private String id;
        private String name;
        private String url;
        private boolean port$set;
        private int port$value;
        private String clientId;
        private String username;
        private String password;
        private boolean cleanSession;
        private boolean mqttVersion$set;
        private CorreoMqttVersion mqttVersion$value;
        private boolean ssl$set;
        private TlsSsl ssl$value;
        private String sslKeystore;
        private String sslKeystorePassword;
        private boolean proxy$set;
        private Proxy proxy$value;
        private String sshHost;
        private boolean sshPort$set;
        private int sshPort$value;
        private int localPort;
        private boolean auth$set;
        private Auth auth$value;
        private String authUsername;
        private String authPassword;
        private String authKeyfile;
        private boolean lwt$set;
        private Lwt lwt$value;
        private String lwtTopic;
        private Qos lwtQoS;
        private boolean lwtRetained;
        private String lwtPayload;

        ConnectionConfigDTOBuilder() {
        }

        public ConnectionConfigDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ConnectionConfigDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConnectionConfigDTOBuilder url(String url) {
            this.url = url;
            return this;
        }

        public ConnectionConfigDTOBuilder port(int port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        public ConnectionConfigDTOBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ConnectionConfigDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public ConnectionConfigDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConnectionConfigDTOBuilder cleanSession(boolean cleanSession) {
            this.cleanSession = cleanSession;
            return this;
        }

        public ConnectionConfigDTOBuilder mqttVersion(CorreoMqttVersion mqttVersion) {
            this.mqttVersion$value = mqttVersion;
            this.mqttVersion$set = true;
            return this;
        }

        public ConnectionConfigDTOBuilder ssl(TlsSsl ssl) {
            this.ssl$value = ssl;
            this.ssl$set = true;
            return this;
        }

        public ConnectionConfigDTOBuilder sslKeystore(String sslKeystore) {
            this.sslKeystore = sslKeystore;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public ConnectionConfigDTOBuilder sslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
            return this;
        }

        public ConnectionConfigDTOBuilder proxy(Proxy proxy) {
            this.proxy$value = proxy;
            this.proxy$set = true;
            return this;
        }

        public ConnectionConfigDTOBuilder sshHost(String sshHost) {
            this.sshHost = sshHost;
            return this;
        }

        public ConnectionConfigDTOBuilder sshPort(int sshPort) {
            this.sshPort$value = sshPort;
            this.sshPort$set = true;
            return this;
        }

        public ConnectionConfigDTOBuilder localPort(int localPort) {
            this.localPort = localPort;
            return this;
        }

        public ConnectionConfigDTOBuilder auth(Auth auth) {
            this.auth$value = auth;
            this.auth$set = true;
            return this;
        }

        public ConnectionConfigDTOBuilder authUsername(String authUsername) {
            this.authUsername = authUsername;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public ConnectionConfigDTOBuilder authPassword(String authPassword) {
            this.authPassword = authPassword;
            return this;
        }

        public ConnectionConfigDTOBuilder authKeyfile(String authKeyfile) {
            this.authKeyfile = authKeyfile;
            return this;
        }

        public ConnectionConfigDTOBuilder lwt(Lwt lwt) {
            this.lwt$value = lwt;
            this.lwt$set = true;
            return this;
        }

        public ConnectionConfigDTOBuilder lwtTopic(String lwtTopic) {
            this.lwtTopic = lwtTopic;
            return this;
        }

        public ConnectionConfigDTOBuilder lwtQoS(Qos lwtQoS) {
            this.lwtQoS = lwtQoS;
            return this;
        }

        public ConnectionConfigDTOBuilder lwtRetained(boolean lwtRetained) {
            this.lwtRetained = lwtRetained;
            return this;
        }

        public ConnectionConfigDTOBuilder lwtPayload(String lwtPayload) {
            this.lwtPayload = lwtPayload;
            return this;
        }

        public ConnectionConfigDTO build() {
            int port$value = this.port$value;
            if (!this.port$set) {
                port$value = ConnectionConfigDTO.$default$port();
            }
            CorreoMqttVersion mqttVersion$value = this.mqttVersion$value;
            if (!this.mqttVersion$set) {
                mqttVersion$value = ConnectionConfigDTO.$default$mqttVersion();
            }
            TlsSsl ssl$value = this.ssl$value;
            if (!this.ssl$set) {
                ssl$value = ConnectionConfigDTO.$default$ssl();
            }
            Proxy proxy$value = this.proxy$value;
            if (!this.proxy$set) {
                proxy$value = ConnectionConfigDTO.$default$proxy();
            }
            int sshPort$value = this.sshPort$value;
            if (!this.sshPort$set) {
                sshPort$value = ConnectionConfigDTO.$default$sshPort();
            }
            Auth auth$value = this.auth$value;
            if (!this.auth$set) {
                auth$value = ConnectionConfigDTO.$default$auth();
            }
            Lwt lwt$value = this.lwt$value;
            if (!this.lwt$set) {
                lwt$value = ConnectionConfigDTO.$default$lwt();
            }
            return new ConnectionConfigDTO(this.id, this.name, this.url, port$value, this.clientId, this.username, this.password, this.cleanSession, mqttVersion$value, ssl$value, this.sslKeystore, this.sslKeystorePassword, proxy$value, this.sshHost, sshPort$value, this.localPort, auth$value, this.authUsername, this.authPassword, this.authKeyfile, lwt$value, this.lwtTopic, this.lwtQoS, this.lwtRetained, this.lwtPayload);
        }

        public String toString() {
            return "ConnectionConfigDTO.ConnectionConfigDTOBuilder(id=" + this.id + ", name=" + this.name + ", url=" + this.url + ", port$value=" + this.port$value + ", clientId=" + this.clientId + ", username=" + this.username + ", password=" + this.password + ", cleanSession=" + this.cleanSession + ", mqttVersion$value=" + this.mqttVersion$value + ", ssl$value=" + this.ssl$value + ", sslKeystore=" + this.sslKeystore + ", sslKeystorePassword=" + this.sslKeystorePassword + ", proxy$value=" + this.proxy$value + ", sshHost=" + this.sshHost + ", sshPort$value=" + this.sshPort$value + ", localPort=" + this.localPort + ", auth$value=" + this.auth$value + ", authUsername=" + this.authUsername + ", authPassword=" + this.authPassword + ", authKeyfile=" + this.authKeyfile + ", lwt$value=" + this.lwt$value + ", lwtTopic=" + this.lwtTopic + ", lwtQoS=" + this.lwtQoS + ", lwtRetained=" + this.lwtRetained + ", lwtPayload=" + this.lwtPayload + ")";
        }
    }
}

