/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.correomqtt.business.model.Qos;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscriptionDTO {
    private String topic;
    private Qos qos;
    private boolean hidden = false;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionDTO that = (SubscriptionDTO)o;
        return this.getTopic().equals(that.getTopic());
    }

    public int hashCode() {
        return Objects.hash(this.getTopic());
    }

    public static SubscriptionDTOBuilder builder() {
        return new SubscriptionDTOBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public Qos getQos() {
        return this.qos;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setQos(Qos qos) {
        this.qos = qos;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public SubscriptionDTO() {
    }

    public SubscriptionDTO(String topic, Qos qos, boolean hidden) {
        this.topic = topic;
        this.qos = qos;
        this.hidden = hidden;
    }

    public static class SubscriptionDTOBuilder {
        private String topic;
        private Qos qos;
        private boolean hidden;

        SubscriptionDTOBuilder() {
        }

        public SubscriptionDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public SubscriptionDTOBuilder qos(Qos qos) {
            this.qos = qos;
            return this;
        }

        public SubscriptionDTOBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public SubscriptionDTO build() {
            return new SubscriptionDTO(this.topic, this.qos, this.hidden);
        }

        public String toString() {
            return "SubscriptionDTO.SubscriptionDTOBuilder(topic=" + this.topic + ", qos=" + this.qos + ", hidden=" + this.hidden + ")";
        }
    }
}

