/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.provider;

import java.io.File;
import org.correomqtt.business.provider.BaseUserFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider
extends BaseUserFileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigProvider.class);
    private static final String PLUGIN_FOLDER = "plugins";
    private static final String PLUGIN_JAR_FOLDER = "jars";
    private static final String PLUGIN_CONFIG_FOLDER = "config";
    private static final String PROTOCOL_XML = "protocol.xml";
    private static ConfigProvider instance = null;

    public static synchronized ConfigProvider getInstance() {
        if (instance == null) {
            instance = new ConfigProvider();
            return instance;
        }
        return instance;
    }

    public String getPluginRootPath() {
        String pluginPath = this.getTargetDirectoryPath() + File.separator + PLUGIN_FOLDER;
        File pluginFolder = new File(pluginPath);
        if (!pluginFolder.exists() && !pluginFolder.mkdir()) {
            return null;
        }
        return pluginPath;
    }

    public String getPluginJarPath() {
        String pluginPath = this.getPluginRootPath() + File.separator + PLUGIN_JAR_FOLDER;
        File pluginFolder = new File(pluginPath);
        if (!pluginFolder.exists() && !pluginFolder.mkdir()) {
            return null;
        }
        return pluginPath;
    }

    public String getPluginConfigPath(String pluginId) {
        String pluginConfigFolderPath = this.getPluginRootPath() + File.separator + PLUGIN_CONFIG_FOLDER + File.separator + pluginId;
        File pluginConfigFolder = new File(pluginConfigFolderPath);
        if (!pluginConfigFolder.exists() && !pluginConfigFolder.mkdirs()) {
            return null;
        }
        return pluginConfigFolderPath;
    }

    public String getPluginProtocol() {
        return this.getPluginRootPath() + File.separator + PROTOCOL_XML;
    }
}

