/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.dispatcher.PersistPublishHistoryDispatcher;
import org.correomqtt.business.dispatcher.PublishGlobalDispatcher;
import org.correomqtt.business.dispatcher.PublishGlobalObserver;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.model.PublishHistoryListDTO;
import org.correomqtt.business.provider.BasePersistHistoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistPublishHistoryProvider
extends BasePersistHistoryProvider<PublishHistoryListDTO>
implements PublishGlobalObserver,
ConnectionLifecycleObserver,
ConfigObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistPublishHistoryProvider.class);
    private static final String HISTORY_FILE_NAME = "publishHistory.json";
    private static final int MAX_ENTRIES = 100;
    private static Map<String, PersistPublishHistoryProvider> instances = new HashMap<String, PersistPublishHistoryProvider>();
    private static Map<String, PublishHistoryListDTO> historyDTOs = new HashMap<String, PublishHistoryListDTO>();

    private PersistPublishHistoryProvider(String id) {
        super(id);
        PublishGlobalDispatcher.getInstance().addObserver(this);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        ConfigDispatcher.getInstance().addObserver(this);
    }

    public static void activate(String id) {
        if (instances.get(id) == null) {
            instances.put(id, new PersistPublishHistoryProvider(id));
        }
    }

    public static synchronized PersistPublishHistoryProvider getInstance(String id) {
        if (instances.get(id) == null) {
            instances.put(id, new PersistPublishHistoryProvider(id));
        }
        return instances.get(id);
    }

    @Override
    protected void readingError(Exception e) {
        PersistPublishHistoryDispatcher.getInstance().errorReadingPublishHistory(e);
    }

    @Override
    String getHistoryFileName() {
        return HISTORY_FILE_NAME;
    }

    @Override
    Class<PublishHistoryListDTO> getDTOClass() {
        return PublishHistoryListDTO.class;
    }

    @Override
    void setDTO(String id, PublishHistoryListDTO dto) {
        historyDTOs.put(id, dto);
    }

    public List<String> getTopics(String connectionId) {
        return historyDTOs.get(connectionId).getTopics();
    }

    @Override
    public void onPublishSucceeded(String connectionId, MessageDTO messageDTO) {
        LOGGER.info("Persisting new publish history entry: {}", (Object)messageDTO.getTopic());
        List<String> topicsSet = this.getTopics(connectionId);
        String topic = messageDTO.getTopic();
        topicsSet.remove(topic);
        topicsSet.add(topic);
        while (topicsSet.size() > 100) {
            LOGGER.info("Removing last entry from publish history, cause limit of {} is reached.", (Object)100);
            topicsSet.remove(topicsSet.iterator().next());
        }
        this.saveHistory(connectionId);
    }

    private void saveHistory(String connectionId) {
        try {
            new ObjectMapper().writeValue(this.getFile(), (Object)historyDTOs.get(connectionId));
            PersistPublishHistoryDispatcher.getInstance().updatedPublishes(connectionId);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write " + this.getHistoryFileName(), (Throwable)e);
            PersistPublishHistoryDispatcher.getInstance().errorWritingPublishHistory(e);
        }
    }

    @Override
    public void onPublishRemoved(String connectionId, MessageDTO messageDTO) {
    }

    @Override
    public void onPublishesCleared(String connectionId) {
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onConnectRunning() {
    }

    @Override
    public void onConnectionFailed(Throwable message) {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onDisconnect() {
        instances.remove(this.getConnectionId());
        historyDTOs.remove(this.getConnectionId());
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onConnectionReconnected() {
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }

    @Override
    public void onConfigDirectoryEmpty() {
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
    }

    @Override
    public void onAppDataNull() {
    }

    @Override
    public void onUserHomeNull() {
    }

    @Override
    public void onFileAlreadyExists() {
    }

    @Override
    public void onInvalidPath() {
    }

    @Override
    public void onInvalidJsonFormat() {
    }

    @Override
    public void onSavingFailed() {
    }

    @Override
    public void onSettingsUpdated() {
    }

    @Override
    public void onConnectionsUpdated() {
        this.removeFileIfConnectionDeleted();
    }

    @Override
    public void onConfigPrepareFailed() {
    }
}

