/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.SecretStoreDispatcher;
import org.correomqtt.business.keyring.KeyringException;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.ConnectionPasswordType;
import org.correomqtt.business.model.PasswordsDTO;
import org.correomqtt.business.provider.BaseUserFileProvider;
import org.correomqtt.business.provider.PasswordRecoverableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretStoreProvider
extends BaseUserFileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretStoreProvider.class);
    private static final String PASSWORD_FILE_NAME = "passwords.json";
    private static final String EX_MSG_PREPARE_CONFIG = "Exception preparing password file.";
    private static final int ITERATION_COUNT = 40000;
    private static final int KEY_LENGTH = 128;
    private PasswordsDTO passwordsDTO;
    private Map<String, String> decryptedPasswords;
    private static SecretStoreProvider instance = null;

    public SecretStoreProvider() {
        try {
            this.prepareFile(PASSWORD_FILE_NAME);
        }
        catch (InvalidPathException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onInvalidPath();
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onFileAlreadyExists();
        }
        catch (DirectoryNotEmptyException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        catch (SecurityException | AccessDeniedException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryNotAccessible();
        }
        catch (IOException | UnsupportedOperationException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigPrepareFailure();
        }
        try {
            this.passwordsDTO = (PasswordsDTO)new ObjectMapper().readValue(this.getFile(), PasswordsDTO.class);
        }
        catch (IOException e) {
            LOGGER.error("Password file can not be read. ", (Throwable)e);
            SecretStoreDispatcher.getInstance().onPasswordFileUnreadable();
            this.passwordsDTO = new PasswordsDTO();
        }
        if (this.passwordsDTO.getSalt() == null) {
            this.passwordsDTO.setSalt(UUID.randomUUID().toString());
        }
    }

    public static synchronized SecretStoreProvider getInstance() {
        if (instance == null) {
            instance = new SecretStoreProvider();
            return instance;
        }
        return instance;
    }

    public void setPassword(String masterPassword, ConnectionConfigDTO connection, ConnectionPasswordType type, String password) throws PasswordRecoverableException {
        this.getDecryptedPasswords(masterPassword).put(this.getPasswordKey(connection, type), password);
    }

    public String getPassword(String masterPassword, ConnectionConfigDTO connection, ConnectionPasswordType type) throws PasswordRecoverableException {
        return this.getDecryptedPasswords(masterPassword).get(this.getPasswordKey(connection, type));
    }

    private String getPasswordKey(ConnectionConfigDTO connection, ConnectionPasswordType type) {
        return connection.getId() + "_" + type.getLabel();
    }

    public void encryptAndSavePasswords(String masterPassword) throws PasswordRecoverableException {
        if (masterPassword == null || masterPassword.isEmpty()) {
            LOGGER.error("Password must not be empty.");
            throw new PasswordRecoverableException();
        }
        Map<String, String> decryptedPasswords = this.getDecryptedPasswords(masterPassword);
        try {
            String encryptedPasswords = "";
            if (decryptedPasswords.size() != 0) {
                encryptedPasswords = this.encrypt(new ObjectMapper().writeValueAsString(decryptedPasswords), this.createSecretKey(masterPassword));
            }
            this.passwordsDTO.setPasswords(encryptedPasswords);
            new ObjectMapper().writeValue(this.getFile(), (Object)this.passwordsDTO);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not encrypt passwords. ", (Throwable)e);
            throw new PasswordRecoverableException();
        }
        catch (IOException e) {
            LOGGER.error("Could not save encrypted passwords. ", (Throwable)e);
            throw new PasswordRecoverableException();
        }
    }

    private Map<String, String> getDecryptedPasswords(String masterPassword) throws PasswordRecoverableException {
        if (this.decryptedPasswords == null) {
            this.decryptedPasswords = this.passwordsDTO.getPasswords() == null ? new HashMap<String, String>() : this.decryptPasswords(masterPassword);
        }
        return this.decryptedPasswords;
    }

    private Map<String, String> decryptPasswords(String masterPassword) throws PasswordRecoverableException {
        String encryptedPasswords = this.passwordsDTO.getPasswords();
        if (masterPassword == null || masterPassword.isEmpty()) {
            LOGGER.error("Password must not be empty.");
            throw new PasswordRecoverableException();
        }
        try {
            if (encryptedPasswords == null || encryptedPasswords.isEmpty()) {
                return new HashMap<String, String>();
            }
            return (Map)new ObjectMapper().readValue(this.decrypt(encryptedPasswords, this.createSecretKey(masterPassword)), (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not decrypt passwords. ", (Throwable)e);
            throw new PasswordRecoverableException();
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not read password file. ", (Throwable)e);
            throw new PasswordRecoverableException();
        }
    }

    public void wipe() {
        this.decryptedPasswords = null;
        this.passwordsDTO.setSalt(UUID.randomUUID().toString());
        this.passwordsDTO.setPasswords("");
        if (this.getFile().exists() && !this.getFile().delete()) {
            throw new KeyringException("Could not delete passwords.json file.");
        }
    }

    private SecretKeySpec createSecretKey(String masterpassword) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec keySpec = new PBEKeySpec(masterpassword.toCharArray(), this.passwordsDTO.getSalt().getBytes(StandardCharsets.UTF_8), 40000, 128);
        SecretKey keyTmp = keyFactory.generateSecret(keySpec);
        return new SecretKeySpec(keyTmp.getEncoded(), "AES");
    }

    private String encrypt(String passwordToEncrypt, SecretKeySpec keyspec) throws GeneralSecurityException {
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeCipher.init(1, keyspec);
        AlgorithmParameters parameters = pbeCipher.getParameters();
        IvParameterSpec ivParameterSpec = parameters.getParameterSpec(IvParameterSpec.class);
        byte[] cryptoText = pbeCipher.doFinal(passwordToEncrypt.getBytes(StandardCharsets.UTF_8));
        byte[] iv = ivParameterSpec.getIV();
        return Base64.getEncoder().encodeToString(iv) + ":" + Base64.getEncoder().encodeToString(cryptoText);
    }

    private String decrypt(String passwordToDecrypt, SecretKeySpec keyspec) throws GeneralSecurityException {
        String iv = passwordToDecrypt.split(":")[0];
        String property = passwordToDecrypt.split(":")[1];
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeCipher.init(2, (Key)keyspec, new IvParameterSpec(Base64.getDecoder().decode(iv)));
        return new String(pbeCipher.doFinal(Base64.getDecoder().decode(property)), StandardCharsets.UTF_8);
    }

    public void ensurePasswordsAreDecrypted(String masterPassword) throws PasswordRecoverableException {
        this.getDecryptedPasswords(masterPassword);
    }
}

