/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import org.correomqtt.business.exception.CorreoMqttDisconnectException;
import org.correomqtt.business.exception.CorreoMqttExecutionException;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.mqtt.CorreoMqttClient;
import org.correomqtt.business.services.BusinessService;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.business.utils.CorreoMqttConnection;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

abstract class BaseService
implements BusinessService {
    protected final String connectionId;

    BaseService(String connectionId) {
        this.connectionId = connectionId;
    }

    CorreoMqttConnection getConnection() {
        return ConnectionHolder.getInstance().getConnection(this.connectionId);
    }

    CorreoMqttClient getClient() {
        return ConnectionHolder.getInstance().getClient(this.connectionId);
    }

    Marker getConnectionMarker() {
        ConnectionConfigDTO connectionConfig = ConnectionHolder.getInstance().getConfig(this.connectionId);
        if (connectionConfig == null) {
            return MarkerFactory.getMarker((String)"Unknown");
        }
        return MarkerFactory.getMarker((String)connectionConfig.getName());
    }

    void callSafeOnClient(ClientConsumerThatMightFail consumer) {
        CorreoMqttClient client = this.getClient();
        if (client != null) {
            try {
                consumer.accept(client);
            }
            catch (Exception e) {
                throw new CorreoMqttExecutionException(e);
            }
        } else {
            throw new CorreoMqttDisconnectException("No client available.");
        }
    }

    @FunctionalInterface
    public static interface ClientConsumerThatMightFail {
        public void accept(CorreoMqttClient var1) throws Exception;
    }
}

